package com.blamejared.controlling.platform;

import com.blamejared.controlling.api.event.ControllingEvents;
import com.blamejared.controlling.api.event.HasConflictingModifierEvent;
import com.blamejared.controlling.api.event.IsKeyCodeModifierEvent;
import com.blamejared.controlling.api.event.SetKeyEvent;
import com.blamejared.controlling.api.event.SetToDefaultEvent;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_3675;

public class FabricPlatformHelper implements IPlatformHelper {
    
    @Override
    public boolean hasConflictingModifier(class_304 keybinding, class_304 other) {
        
        if(FabricLoader.getInstance().isModLoaded("fabric")) {
            return ControllingEvents.HAS_CONFLICTING_MODIFIERS_EVENT.invoker()
                    .handle(new HasConflictingModifierEvent(keybinding, other));
        }
        return IPlatformHelper.super.hasConflictingModifier(keybinding, other);
        
    }
    
    @Override
    public void setKey(class_315 options, class_304 keybinding, class_3675.class_306 key) {
        
        boolean handled = FabricLoader.getInstance().isModLoaded("fabric")
                && ControllingEvents.SET_KEY_EVENT.invoker().handle(new SetKeyEvent(options, keybinding, key));
        if(!handled) {
            IPlatformHelper.super.setKey(options, keybinding, key);
        }
    }
    
    @Override
    public void setToDefault(class_315 options, class_304 keybinding) {
        
        boolean handled = FabricLoader.getInstance().isModLoaded("fabric")
                && ControllingEvents.SET_TO_DEFAULT_EVENT.invoker().handle(new SetToDefaultEvent(options, keybinding));
        if(!handled) {
            IPlatformHelper.super.setToDefault(options, keybinding);
        }
    }
    
    @Override
    public boolean isKeyCodeModifier(class_3675.class_306 key) {
        
        if(FabricLoader.getInstance().isModLoaded("fabric")) {
            return ControllingEvents.IS_KEY_CODE_MODIFIER_EVENT.invoker().handle(new IsKeyCodeModifierEvent(key));
        }
        return IPlatformHelper.super.isKeyCodeModifier(key);
        
    }
    
}
