package com.blamejared.clumps.platform;

import com.blamejared.clumps.ClumpsCommon;

import java.util.ServiceLoader;

public class Services {
    
    public static final IEventHelper EVENT = load(IEventHelper.class);
    public static final IPlatformHelper PLATFORM = load(IPlatformHelper.class);
    
    
    public static <T> T load(Class<T> clazz) {
        
        final T loadedService = ServiceLoader.load(clazz)
                .findFirst()
                .orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        ClumpsCommon.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
    
}
