package com.blamejared.clumps.api.events;

import net.minecraft.class_1657;

/**
 * Fired before an item is repaired, if a repair is performed, then any leftover experience should be set back to this event.
 */
public class RepairEvent implements IValueEvent {
    
    private final class_1657 player;
    private int value;
    
    public RepairEvent(class_1657 player, int value) {
        
        this.player = player;
        this.value = value;
    }
    
    /**
     * Sets the amount of experience left after repairing.
     *
     * @param value The new value to set.
     */
    @Override
    public void setValue(int value) {
        
        this.value = value;
    }
    
    /**
     * Gets the amount of experience to be used by the repair.
     *
     * @return The amount of experience to be used by the repair.
     */
    @Override
    public int getValue() {
        
        return this.value;
    }
    
    /**
     * Gets the player whose items are being repaired.
     *
     * @return The player whose items are being repaired.
     */
    @Override
    public class_1657 getPlayer() {
        
        return this.player;
    }
    
}