package com.blamejared.ambientenvironment;

import com.blamejared.ambientenvironment.mixin.BiomeColorsAccessor;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1163;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_3543;
import net.minecraft.class_6539;
import net.minecraft.class_6677;

public class AmbientEnvironmentCommon {
    
    public static final int NOISE_OCTAVES = 2;
    public static final List<Integer> OCTAVES = IntStream.rangeClosed(0, NOISE_OCTAVES).boxed().toList();
    public static final class_3543 GRASS_NOISE = new class_3543(new class_6677("NOISE_GRASS".hashCode()), OCTAVES);
    public static final class_3543 WATER_NOISE = new class_3543(new class_6677("NOISE_WATER".hashCode()), OCTAVES);
    
    public static final class_6539 GRASS_RESOLVER = class_156.method_656(() -> {
        final var baseResolver = class_1163.field_5665;
        return (biome, x, z) -> modifyColour(GRASS_NOISE, baseResolver, biome, x, z, 8f, 0.25f);
    });
    
    public static final class_6539 WATER_RESOLVER = class_156.method_656(() -> {
        final var baseResolver = class_1163.field_5666;
        return (biome, x, z) -> modifyColour(WATER_NOISE, baseResolver, biome, x, z, 16f, 0.3f);
    });
    
    public static void init() {
        
        BiomeColorsAccessor.ambientenvironment$setGrassColorResolver(AmbientEnvironmentCommon.GRASS_RESOLVER);
        BiomeColorsAccessor.ambientenvironment$setWaterColorResolver(AmbientEnvironmentCommon.WATER_RESOLVER);
    }
    
    
    private static int modifyColour(class_3543 generator, class_6539 resolver, class_1959 biome, double x, double z, double scale, double darkness) {
        
        final int base = resolver.getColor(biome, x, z);
        double value = generator.method_16451(x / scale, z / scale, false);
        value = curve(0, 1, remap(value, -((1 << NOISE_OCTAVES) - 1), (1 << NOISE_OCTAVES) - 1, 0, 1)) * darkness;
        return blend(base, 0, (float) (value));
    }
    
    public static double remap(final double value, final double currentLow, final double currentHigh, final double newLow, final double newHigh) {
        
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }
    
    private static float getRed(final int hex) {
        
        return ((hex >> 16) & 0xFF) / 255f;
    }
    
    private static float getGreen(final int hex) {
        
        return ((hex >> 8) & 0xFF) / 255f;
    }
    
    private static float getBlue(final int hex) {
        
        return ((hex) & 0xFF) / 255f;
    }
    
    private static float getAlpha(final int hex) {
        
        return ((hex >> 24) & 0xff) / 255f;
    }
    
    private static float[] getARGB(final int hex) {
        
        return new float[] {getAlpha(hex), getRed(hex), getGreen(hex), getBlue(hex)};
    }
    
    private static int toInt(final float[] argb) {
        
        final int r = (int) Math.floor(argb[1] * 255) & 0xFF;
        final int g = (int) Math.floor(argb[2] * 255) & 0xFF;
        final int b = (int) Math.floor(argb[3] * 255) & 0xFF;
        final int a = (int) Math.floor(argb[0] * 255) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + (b);
    }
    
    
    public static double curve(final double start, final double end, double amount) {
        
        amount = class_3532.method_15350(amount, 0, 1);
        amount = class_3532.method_15350((amount - start) / (end - start), 0, 1);
        return class_3532.method_15350(0.5 + 0.5 * Math.sin(Math.cos(Math.PI * Math.tan(90 * amount))) * Math.cos(Math.sin(Math.tan(amount))), 0, 1);
    }
    
    public static int blend(final int color1, final int color2, final float ratio) {
        
        final float ir = 1.0f - ratio;
        
        final float[] rgb1 = getARGB(color2);
        final float[] rgb2 = getARGB(color1);
        
        return toInt(new float[] {rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }
    
}
