/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.recipe;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifierRegistry;
import com.almostreliable.unified.compat.viewer.ClientRecipeTracker;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.DuplicateConfig;
import com.almostreliable.unified.unification.UnificationSettingsImpl;
import com.almostreliable.unified.unification.recipe.RecipeJsonImpl;
import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.unification.recipe.RecipeLinkFactory;
import com.almostreliable.unified.unification.recipe.UnificationHelperImpl;
import com.almostreliable.unified.utils.JsonCompare;
import com.almostreliable.unified.utils.RecipeTypePropertiesLogger;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeTransformer {
    private final CustomIngredientUnifierRegistry ingredientUnifierRegistry;
    private final RecipeUnifierRegistry recipeUnifierRegistry;
    private final Collection<? extends UnificationSettings> unificationSettings;
    private final RecipeLinkFactory recipeLinkFactory;
    private final DuplicateConfig duplicateConfig;
    private final RecipeTypePropertiesLogger propertiesLogger = new RecipeTypePropertiesLogger();

    public RecipeTransformer(CustomIngredientUnifierRegistry ingredientUnifierRegistry, RecipeUnifierRegistry recipeUnifierRegistry, Collection<? extends UnificationSettings> unificationSettings, RecipeLinkFactory recipeLinkFactory) {
        this.ingredientUnifierRegistry = ingredientUnifierRegistry;
        this.recipeUnifierRegistry = recipeUnifierRegistry;
        this.unificationSettings = unificationSettings;
        this.recipeLinkFactory = recipeLinkFactory;
        this.duplicateConfig = Config.load("duplicates", DuplicateConfig.SERIALIZER);
    }

    public Result transformRecipes(Map<ResourceLocation, JsonElement> recipes) {
        Stopwatch transformationTimer = Stopwatch.createStarted();
        AlmostUnifiedCommon.LOGGER.info("Recipe count: {}", (Object)recipes.size());
        ClientRecipeTracker.RawBuilder tracker = AlmostUnifiedCommon.STARTUP_CONFIG.isServerOnly() ? null : new ClientRecipeTracker.RawBuilder();
        Result result = new Result();
        Map<ResourceLocation, List<RecipeLink>> byType = this.groupRecipesByType(recipes);
        for (Map.Entry<ResourceLocation, List<RecipeLink>> entry : byType.entrySet()) {
            ResourceLocation type = entry.getKey();
            List<RecipeLink> recipeLinks = entry.getValue();
            if (recipeLinks.isEmpty()) continue;
            this.transformRecipes(type, recipeLinks, recipes, tracker);
            result.addAll(recipeLinks);
        }
        AlmostUnifiedCommon.LOGGER.info("Recipe count afterwards: {} (done in {})", (Object)recipes.size(), (Object)transformationTimer.stop());
        for (UnificationSettings unificationSettings : this.unificationSettings) {
            ((UnificationSettingsImpl)unificationSettings).clearCache();
        }
        this.duplicateConfig.clearCache();
        if (tracker != null) {
            recipes.putAll(tracker.compute());
        }
        return result;
    }

    private void transformRecipes(ResourceLocation type, List<RecipeLink> recipeLinks, Map<ResourceLocation, JsonElement> allRecipes, @Nullable ClientRecipeTracker.RawBuilder tracker) {
        LinkedHashSet<RecipeLink> unified = this.unifyRecipes(recipeLinks, r -> allRecipes.put(r.getId(), (JsonElement)r.getUnified()));
        if (!this.duplicateConfig.isRecipeTypeIgnored(type)) {
            Set<RecipeLink.DuplicateLink> duplicates = this.handleDuplicates(this.duplicateConfig.shouldCompareAll() ? recipeLinks : unified, recipeLinks);
            duplicates.stream().flatMap(d -> d.getRecipesWithoutMaster().stream()).forEach(r -> allRecipes.remove(r.getId()));
        }
        if (tracker != null) {
            unified.forEach(tracker::add);
        }
    }

    public Map<ResourceLocation, List<RecipeLink>> groupRecipesByType(Map<ResourceLocation, JsonElement> recipes) {
        ConcurrentHashMap<ResourceLocation, List<RecipeLink>> groupedRecipes = new ConcurrentHashMap<ResourceLocation, List<RecipeLink>>();
        int recipeCount = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : recipes.entrySet()) {
            RecipeLink link;
            JsonObject recipeJson;
            JsonElement recipe = entry.getValue();
            if (!(recipe instanceof JsonObject) || (recipeJson = (JsonObject)recipe).isEmpty() || (link = this.recipeLinkFactory.create(entry.getKey(), recipeJson)) == null) continue;
            ++recipeCount;
            groupedRecipes.computeIfAbsent(link.getType(), k -> new ArrayList()).add(link);
        }
        for (List recipesByType : groupedRecipes.values()) {
            recipesByType.sort(Comparator.naturalOrder());
        }
        AlmostUnifiedCommon.LOGGER.info("{} out of {} recipes were loaded for unification.", (Object)recipeCount, (Object)recipes.size());
        return groupedRecipes;
    }

    private Set<RecipeLink.DuplicateLink> handleDuplicates(Collection<RecipeLink> recipeLinks, List<RecipeLink> linksToCompare) {
        HashSet<RecipeLink.DuplicateLink> duplicates = new HashSet<RecipeLink.DuplicateLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            if (!this.handleDuplicate(recipeLink, linksToCompare) || recipeLink.getDuplicateLink() == null) continue;
            duplicates.add(recipeLink.getDuplicateLink());
        }
        return duplicates;
    }

    private boolean handleDuplicate(RecipeLink curRecipe, List<RecipeLink> recipes) {
        if (this.duplicateConfig.isRecipeIdIgnored(curRecipe)) {
            return false;
        }
        JsonCompare.CompareContext compareContext = this.duplicateConfig.getCompareContext(curRecipe);
        boolean foundDuplicate = false;
        for (RecipeLink recipeLink : recipes) {
            if (recipeLink == curRecipe || this.duplicateConfig.isRecipeIdIgnored(recipeLink)) continue;
            foundDuplicate |= curRecipe.handleDuplicate(recipeLink, compareContext);
        }
        return foundDuplicate;
    }

    private LinkedHashSet<RecipeLink> unifyRecipes(List<RecipeLink> recipeLinks, Consumer<RecipeLink> onUnified) {
        LinkedHashSet<RecipeLink> unified = new LinkedHashSet<RecipeLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            this.unifyRecipe(recipeLink);
            if (!recipeLink.isUnified()) continue;
            onUnified.accept(recipeLink);
            unified.add(recipeLink);
        }
        return unified;
    }

    public void unifyRecipe(RecipeLink recipe) {
        try {
            JsonObject recipeCopy = recipe.getOriginal().deepCopy();
            RecipeJsonImpl json = new RecipeJsonImpl(recipe.getId(), recipeCopy);
            for (UnificationSettings unificationSettings : this.unificationSettings) {
                if (!unificationSettings.shouldIncludeRecipe(recipe)) continue;
                UnificationHelperImpl helper = new UnificationHelperImpl(this.ingredientUnifierRegistry, unificationSettings);
                RecipeUnifier unifier = this.recipeUnifierRegistry.getRecipeUnifier(recipe);
                unifier.unify(helper, json);
            }
            if (!recipe.getOriginal().equals((Object)recipeCopy)) {
                recipe.setUnified(recipeCopy);
            }
            this.propertiesLogger.log(recipe.getType(), recipe.getOriginal());
        }
        catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error("Error unifying recipe '{}'", (Object)recipe.getId(), (Object)e);
        }
    }

    public static class Result {
        private final Multimap<ResourceLocation, RecipeLink> allRecipesByType = HashMultimap.create();
        private final Multimap<ResourceLocation, RecipeLink> unifiedRecipesByType = HashMultimap.create();
        private final Multimap<ResourceLocation, RecipeLink.DuplicateLink> duplicatesByType = HashMultimap.create();
        @Nullable
        private Set<ResourceLocation> unifiedRecipeIds;

        private void add(RecipeLink link) {
            if (this.allRecipesByType.containsEntry((Object)link.getType(), (Object)link)) {
                throw new IllegalStateException("already tracking recipe type " + String.valueOf(link.getType()));
            }
            this.allRecipesByType.put((Object)link.getType(), (Object)link);
            if (link.isUnified()) {
                this.unifiedRecipesByType.put((Object)link.getType(), (Object)link);
            }
            if (link.hasDuplicateLink()) {
                this.duplicatesByType.put((Object)link.getType(), (Object)link.getDuplicateLink());
            }
        }

        private void addAll(Collection<RecipeLink> links) {
            links.forEach(this::add);
        }

        public Collection<RecipeLink> getRecipesByType(ResourceLocation type) {
            return Collections.unmodifiableCollection(this.allRecipesByType.get((Object)type));
        }

        public Collection<ResourceLocation> getUnifiedRecipes() {
            if (this.unifiedRecipeIds == null) {
                this.unifiedRecipeIds = this.unifiedRecipesByType.values().stream().map(RecipeLink::getId).collect(Collectors.toSet());
            }
            return this.unifiedRecipeIds;
        }

        public Collection<RecipeLink> getUnifiedRecipesByType(ResourceLocation type) {
            return Collections.unmodifiableCollection(this.unifiedRecipesByType.get((Object)type));
        }

        public Collection<RecipeLink.DuplicateLink> getDuplicateRecipesByType(ResourceLocation type) {
            return Collections.unmodifiableCollection(this.duplicatesByType.get((Object)type));
        }

        public int getUnifiedRecipesCount() {
            return this.unifiedRecipesByType.size();
        }

        public int getDuplicateRecipesCount() {
            return this.duplicatesByType.size();
        }

        public int getTotalDuplicateRecipesCount() {
            return this.duplicatesByType.values().stream().mapToInt(l -> l.getRecipes().size()).sum();
        }

        public Set<ResourceLocation> getUnifiedRecipeTypes() {
            return this.unifiedRecipesByType.keySet();
        }
    }
}

