package com.almostreliable.unified.core;

import net.minecraft.resources.ResourceLocation;

import com.almostreliable.unified.api.constant.ModConstants;
import com.almostreliable.unified.api.plugin.AlmostUnifiedNeoPlugin;
import com.almostreliable.unified.api.plugin.AlmostUnifiedPlugin;
import com.almostreliable.unified.api.unification.bundled.ShapedRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifierRegistry;
import com.almostreliable.unified.compat.unification.ArsNouveauRecipeUnifier;
import com.almostreliable.unified.compat.unification.CompoundIngredientUnifier;
import com.almostreliable.unified.compat.unification.CyclicRecipeUnifier;
import com.almostreliable.unified.compat.unification.EnderIORecipeUnifier;
import com.almostreliable.unified.compat.unification.IntegratedDynamicsRecipeUnifier;
import com.almostreliable.unified.compat.unification.MekanismRecipeUnifier;
import com.almostreliable.unified.compat.unification.OccultismRecipeUnifier;
import com.almostreliable.unified.compat.unification.ProductiveTreesRecipeUnifier;
import com.almostreliable.unified.compat.unification.TheurgyRecipeUnifier;
import com.almostreliable.unified.utils.Utils;

import java.util.List;

@AlmostUnifiedNeoPlugin
public class NeoForgePlugin implements AlmostUnifiedPlugin {

    @Override
    public ResourceLocation getPluginId() {
        return Utils.getRL("neoforge");
    }

    @Override
    public void registerRecipeUnifiers(RecipeUnifierRegistry registry) {
        List.of(
            ModConstants.ARS_CREO,
            ModConstants.ARS_ELEMENTAL,
            ModConstants.ARS_NOUVEAU,
            ModConstants.ARS_SCALAES
        ).forEach(modId -> registry.registerForModId(modId, new ArsNouveauRecipeUnifier()));
        registry.registerForModId(ModConstants.CYCLIC, new CyclicRecipeUnifier());
        registry.registerForRecipeType(
            ResourceLocation.fromNamespaceAndPath(ModConstants.ENDER_IO, "sag_milling"),
            new EnderIORecipeUnifier()
        );
        registry.registerForModId(ModConstants.INTEGRATED_DYNAMICS, new IntegratedDynamicsRecipeUnifier());
        registry.registerForModId(ModConstants.MEKANISM, new MekanismRecipeUnifier());
        registry.registerForModId(ModConstants.OCCULTISM, new OccultismRecipeUnifier());
        registry.registerForModId(ModConstants.PRODUCTIVE_TREES, new ProductiveTreesRecipeUnifier());
        registry.registerForModId(ModConstants.THEURGY, new TheurgyRecipeUnifier());
        registry.registerForRecipeType(
            ResourceLocation.fromNamespaceAndPath(ModConstants.THEURGY, "divination_rod"),
            ShapedRecipeUnifier.INSTANCE
        );
    }

    @Override
    public void registerCustomIngredientUnifiers(CustomIngredientUnifierRegistry registry) {
        registry.registerForType(
            ResourceLocation.fromNamespaceAndPath("neoforge", "compound"),
            new CompoundIngredientUnifier()
        );
    }
}
