/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.recipe;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.bundled.ShapedRecipeUnifier;
import com.almostreliable.unified.api.unification.bundled.SmithingRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeData;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifierRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class RecipeUnifierRegistryImpl
implements RecipeUnifierRegistry {
    private final Map<class_2960, RecipeUnifier> recipeUnifiersByRecipeType = new HashMap<class_2960, RecipeUnifier>();
    private final Map<String, RecipeUnifier> recipeUnifiersByModId = new HashMap<String, RecipeUnifier>();

    @Override
    public void registerForRecipeType(class_2960 recipeType, RecipeUnifier recipeUnifier) {
        this.recipeUnifiersByRecipeType.put(recipeType, recipeUnifier);
    }

    @Override
    public void registerForModId(String modId, RecipeUnifier recipeUnifier) {
        this.recipeUnifiersByModId.put(modId, recipeUnifier);
    }

    @Override
    public RecipeUnifier getRecipeUnifier(RecipeData recipeData) {
        class_2960 type = recipeData.getType();
        RecipeUnifier byType = this.recipeUnifiersByRecipeType.get(type);
        if (byType != null) {
            return byType;
        }
        RecipeUnifier byMod = this.recipeUnifiersByModId.get(type.method_12836());
        if (byMod != null) {
            return byMod;
        }
        if (SmithingRecipeUnifier.isApplicable(recipeData)) {
            return SmithingRecipeUnifier.INSTANCE;
        }
        if (ShapedRecipeUnifier.isApplicable(recipeData)) {
            return ShapedRecipeUnifier.INSTANCE;
        }
        return GenericRecipeUnifier.INSTANCE;
    }
}

