package com.almostreliable.unified.unification;

import com.almostreliable.unified.api.unification.UnificationEntry;

import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class UnificationEntryImpl<T> implements UnificationEntry<T> {

    private final class_2378<T> registry;
    private final class_5321<T> key;

    @Nullable private T value;
    @Nullable private class_6862<T> tag;

    public UnificationEntryImpl(class_2378<T> registry, class_2960 key) {
        this.registry = registry;
        this.key = class_5321.method_29179(registry.method_30517(), key);
    }

    public UnificationEntryImpl(class_2378<T> registry, T entry) {
        this.key = registry
            .method_29113(entry)
            .orElseThrow(() -> new IllegalArgumentException("Entry " + entry + " does not belong to " + registry));
        this.registry = registry;
        this.value = entry;
    }

    @Override
    public class_5321<T> key() {
        return key;
    }

    @Override
    public class_2960 id() {
        return key.method_29177();
    }

    @Override
    public T value() {
        if (value == null) {
            value = registry
                .method_31189(key)
                .orElseThrow(() -> new IllegalStateException("entry " + key + " not found in " + registry));
        }

        return value;
    }

    @Override
    public class_6862<T> tag() {
        if (tag == null) {
            throw new IllegalStateException("tag not bound to " + this);
        }

        return tag;
    }

    @Override
    public class_6880.class_6883<T> asHolderOrThrow() {
        return registry.method_40290(key);
    }

    public void bindTag(class_6862<T> tag) {
        if (this.tag != null) {
            throw new IllegalStateException("tag already bound to " + this.tag);
        }

        this.tag = tag;
    }

    @Override
    public int hashCode() {
        return Objects.hash(key);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof UnificationEntry<?> holder && holder.key() == key();
    }

    @Override
    public String toString() {
        return "UnificationEntry{" + key() + "}";
    }
}
