package com.almostreliable.unified.compat.viewer;

import I;
import com.almostreliable.unified.api.constant.ModConstants;
import com.almostreliable.unified.compat.viewer.ClientRecipeTracker.ClientRecipeLink;
import com.almostreliable.unified.utils.Utils;

import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;

@REIPluginCompatIgnore
@JeiPlugin
public class AlmostJEI implements IModPlugin {

    @Override
    public class_2960 getPluginUid() {
        return Utils.getRL(ModConstants.JEI);
    }

    @Override
    public void onRuntimeAvailable(IJeiRuntime jei) {
        Collection<class_1799> items = new ArrayList<>();
        for (class_6880<class_1792> itemHolder : class_7923.field_41178.method_40286(ItemHider.HIDE_TAG)) {
            items.add(new class_1799(itemHolder));
        }

        if (!items.isEmpty()) {
            jei.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM_STACK, items);
        }
    }

    @Override
    public void registerAdvanced(IAdvancedRegistration registration) {
        var recipeTypes = registration.getJeiHelpers().getAllRecipeTypes();
        recipeTypes.forEach(rt -> registration.addRecipeCategoryDecorator(rt, new Decorator<>()));
    }

    private static class Decorator<T> implements IRecipeCategoryDecorator<T> {

        private static final int RECIPE_BORDER_PADDING = 4;

        @Override
        public void draw(T recipe, IRecipeCategory<T> recipeCategory, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
            var recipeLink = resolveLink(recipeCategory, recipe);
            if (recipeLink == null) return;

            var pX = recipeCategory.getWidth() + (2 * RECIPE_BORDER_PADDING) - RecipeIndicator.RENDER_SIZE;
            var pY = recipeCategory.getHeight() + (2 * RECIPE_BORDER_PADDING) - RecipeIndicator.RENDER_SIZE;
            RecipeIndicator.renderIndicator(guiGraphics, pX, pY, RecipeIndicator.RENDER_SIZE);

            if (mouseX >= pX && mouseX <= pX + RecipeIndicator.RENDER_SIZE &&
                mouseY >= pY && mouseY <= pY + RecipeIndicator.RENDER_SIZE) {
                RecipeIndicator.renderTooltip(guiGraphics, recipeLink, mouseX, mouseY);
            }
        }

        @Nullable
        private static <R> ClientRecipeLink resolveLink(IRecipeCategory<R> recipeCategory, R recipe) {
            var recipeId = recipeCategory.getRegistryName(recipe);
            if (recipeId == null) return null;

            return CRTLookup.getLink(recipeId);
        }
    }
}
