package com.almostreliable.unified.api.unification.recipe;

import net.minecraft.class_2960;

/**
 * Basic information about a recipe used for determination of the correct {@link RecipeUnifier}.
 *
 * @since 1.0.0
 */
public interface RecipeData {

    /**
     * Returns the recipe id as a {@link class_2960}.
     *
     * @return the id
     */
    class_2960 getId();

    /**
     * Returns the recipe type as a {@link class_2960}.
     *
     * @return the recipe type
     */
    class_2960 getType();

    /**
     * Checks if the current recipe contains the property with the given key.
     *
     * @param key the key of the property to check for
     * @return true if the recipe contains the property, false otherwise
     */
    boolean hasProperty(String key);
}
