package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.compat.HideHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public final class UncoveredRecipesDumper {

    private UncoveredRecipesDumper() {}

    public static void write(Map<class_2960, JsonElement> recipes) {
        var hidingMap = HideHelper.createHidingMap();
        FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), "uncovered_recipes.txt", sb -> {
            recipes.forEach((recipeId, json) -> {
                if (json instanceof JsonObject obj) {
                    write(recipeId, obj, hidingMap, sb);
                }
            });
        });
    }

    private static void write(class_2960 recipeId, JsonObject json, Multimap<UnifyTag<class_1792>, class_2960> hidingMap, StringBuilder sb) {
        String jsonStr = json.toString();
        Multimap<UnifyTag<class_1792>, class_2960> foundEntries = HashMultimap.create();
        hidingMap.asMap().forEach((tag, items) -> {
            for (class_2960 item : items) {
                if (jsonStr.contains(item.toString())) {
                    foundEntries.put(tag, item);
                }
            }
        });

        if (foundEntries.isEmpty()) return;

        String type = Optional.ofNullable(json.get("type")).map(JsonElement::getAsString).orElse("");
        sb
                .append("Id: ").append(recipeId).append("\n")
                .append("Type: ").append(type).append("\n")
                .append("Json: ").append(jsonStr).append("\n")
                .append("Items: ").append("\n");
        foundEntries.asMap().forEach((tag, items) -> {
            for (class_2960 item : items) {
                sb.append("\t").append(item).append(" (#").append(tag.location()).append(")").append("\n");
            }
        });

        sb.append("\n");
    }
}
