package com.almostreliable.unified.recipe.unifier;

import com.almostreliable.unified.api.recipe.RecipeConstants;
import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class RecipeHandlerFactory {

    private static final class_2960 SMITHING_TYPE = new class_2960("minecraft:smithing");

    private final Map<class_2960, RecipeUnifier> transformersByType = new HashMap<>();
    private final Map<String, RecipeUnifier> transformersByModId = new HashMap<>();

    public void fillUnifier(RecipeUnifierBuilder builder, RecipeContext context) {
        GenericRecipeUnifier.INSTANCE.collectUnifier(builder);

        if (context.hasProperty(ShapedRecipeKeyUnifier.PATTERN_PROPERTY) &&
            context.hasProperty(ShapedRecipeKeyUnifier.KEY_PROPERTY)) {
            ShapedRecipeKeyUnifier.INSTANCE.collectUnifier(builder);
        }

        if (context.hasProperty(SmithingRecipeUnifier.ADDITION_PROPERTY) &&
            context.hasProperty(SmithingRecipeUnifier.BASE_PROPERTY) &&
            context.hasProperty(RecipeConstants.RESULT)) {
            SmithingRecipeUnifier.INSTANCE.collectUnifier(builder);
        }

        class_2960 type = context.getType();
        RecipeUnifier byMod = transformersByModId.get(type.method_12836());
        if (byMod != null) {
            byMod.collectUnifier(builder);
        }

        RecipeUnifier byType = transformersByType.get(type);
        if (byType != null) {
            byType.collectUnifier(builder);
        }
    }

    public void registerForType(class_2960 type, RecipeUnifier transformer) {
        transformersByType.put(type, transformer);
    }

    public void registerForMod(String mod, RecipeUnifier transformer) {
        transformersByModId.put(mod, transformer);
    }
}
