/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.ModPriorities;
import com.almostreliable.unified.api.unification.StoneVariants;
import com.almostreliable.unified.api.unification.TagSubstitutions;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.unification.UnificationEntryImpl;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class UnificationLookupImpl
implements UnificationLookup {
    private final ModPriorities modPriorities;
    private final StoneVariants stoneVariants;
    private final TagSubstitutions tagSubstitutions;
    private final Map<class_6862<class_1792>, Set<UnificationEntry<class_1792>>> tagsToEntries;
    private final Map<class_2960, UnificationEntry<class_1792>> idsToEntries;

    private UnificationLookupImpl(ModPriorities modPriorities, StoneVariants stoneVariants, TagSubstitutions tagSubstitutions, Map<class_6862<class_1792>, Set<UnificationEntry<class_1792>>> tagsToEntries, Map<class_2960, UnificationEntry<class_1792>> idsToEntries) {
        this.modPriorities = modPriorities;
        this.stoneVariants = stoneVariants;
        this.tagSubstitutions = tagSubstitutions;
        this.tagsToEntries = tagsToEntries;
        this.idsToEntries = idsToEntries;
    }

    @Override
    public Collection<class_6862<class_1792>> getTags() {
        return this.tagsToEntries.keySet();
    }

    @Override
    public Collection<UnificationEntry<class_1792>> getTagEntries(class_6862<class_1792> tag) {
        return this.tagsToEntries.getOrDefault(tag, Collections.emptySet());
    }

    @Override
    @Nullable
    public UnificationEntry<class_1792> getItemEntry(class_2960 item) {
        return this.idsToEntries.get(item);
    }

    @Override
    @Nullable
    public class_6862<class_1792> getRelevantItemTag(class_2960 item) {
        UnificationEntry<class_1792> entry = this.idsToEntries.get(item);
        return entry == null ? null : entry.tag();
    }

    @Override
    @Nullable
    public UnificationEntry<class_1792> getVariantItemTarget(class_2960 item) {
        class_6862<class_1792> tag = this.getRelevantItemTag(item);
        if (tag == null) {
            return null;
        }
        if (this.stoneVariants.isOreTag(tag)) {
            String stoneVariant = this.stoneVariants.getStoneVariant(item);
            return this.getTagTargetItem(tag, itemId -> stoneVariant.equals(this.stoneVariants.getStoneVariant((class_2960)itemId)));
        }
        return this.getTagTargetItem(tag);
    }

    @Override
    @Nullable
    public UnificationEntry<class_1792> getTagTargetItem(class_6862<class_1792> tag, Predicate<class_2960> itemFilter) {
        class_6862<class_1792> substituteTag = this.tagSubstitutions.getSubstituteTag(tag);
        class_6862<class_1792> tagToCheck = substituteTag != null ? substituteTag : tag;
        List<UnificationEntry<class_1792>> items = this.getTagEntries(tagToCheck).stream().filter(entry -> itemFilter.test(entry.id())).sorted(Comparator.comparingInt(value -> value.id().toString().length())).toList();
        return items.isEmpty() ? null : this.modPriorities.findTargetItem(tagToCheck, items);
    }

    @Override
    public boolean isUnifiedIngredientItem(class_1856 ingredient, class_1799 item) {
        HashSet<class_6862<class_1792>> checkedTags = new HashSet<class_6862<class_1792>>();
        for (class_1799 stack : ingredient.method_8105()) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            class_6862<class_1792> relevantTag = this.getRelevantItemTag(itemId);
            if (relevantTag == null || checkedTags.contains(relevantTag)) continue;
            checkedTags.add(relevantTag);
            if (!item.method_31573(relevantTag)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final Map<UnificationEntry<class_1792>, class_6862<class_1792>> entriesToTags = new HashMap<UnificationEntry<class_1792>, class_6862<class_1792>>();
        private final Map<class_6862<class_1792>, Set<UnificationEntry<class_1792>>> tagsToEntries = new HashMap<class_6862<class_1792>, Set<UnificationEntry<class_1792>>>();

        private void put(class_6862<class_1792> tag, UnificationEntry<class_1792> entry) {
            if (this.entriesToTags.containsKey(entry)) {
                class_6862<class_1792> boundTag = this.entriesToTags.get(entry);
                AlmostUnifiedCommon.LOGGER.error("Unification entry for item '{}' with tag '#{}' is already part of tag '#{}'.", (Object)entry.id(), (Object)tag.comp_327(), (Object)boundTag.comp_327());
                return;
            }
            this.entriesToTags.put(entry, tag);
            this.tagsToEntries.computeIfAbsent(tag, $ -> new HashSet()).add(entry);
        }

        public Builder put(class_6862<class_1792> tag, class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.put(tag, new UnificationEntryImpl<class_2960>((class_2378<class_2960>)class_7923.field_41178, id));
            }
            return this;
        }

        public Builder put(class_6862<class_1792> tag, class_1792 ... items) {
            for (class_1792 item : items) {
                this.put(tag, new UnificationEntryImpl<class_1792>((class_2378<class_1792>)class_7923.field_41178, item));
            }
            return this;
        }

        public UnificationLookup build(ModPriorities modPriorities, StoneVariants stoneVariants, TagSubstitutions tagSubstitutions) {
            ImmutableMap.Builder tagsToEntriesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder idsToEntriesBuilder = ImmutableMap.builder();
            this.tagsToEntries.forEach((tag, entries) -> {
                ImmutableSet.Builder entrySetBuilder = ImmutableSet.builder();
                for (UnificationEntry entry : entries) {
                    entrySetBuilder.add((Object)entry);
                    ((UnificationEntryImpl)entry).bindTag(tag);
                    idsToEntriesBuilder.put((Object)entry.id(), (Object)entry);
                }
                tagsToEntriesBuilder.put(tag, (Object)entrySetBuilder.build());
            });
            return new UnificationLookupImpl(modPriorities, stoneVariants, tagSubstitutions, (Map<class_6862<class_1792>, Set<UnificationEntry<class_1792>>>)tagsToEntriesBuilder.build(), (Map<class_2960, UnificationEntry<class_1792>>)idsToEntriesBuilder.build());
        }
    }
}

