package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.ModPriorities;
import com.almostreliable.unified.api.unification.UnificationEntry;

import org.jetbrains.annotations.Nullable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_6862;

public final class ModPrioritiesImpl implements ModPriorities {

    private final List<String> modPriorities;
    private final Map<class_6862<class_1792>, String> priorityOverrides;

    public ModPrioritiesImpl(List<String> modPriorities, Map<class_6862<class_1792>, String> priorityOverrides) {
        this.modPriorities = modPriorities;
        this.priorityOverrides = priorityOverrides;
    }

    @Nullable
    @Override
    public String getPriorityOverride(class_6862<class_1792> tag) {
        return priorityOverrides.get(tag);
    }

    @Nullable
    @Override
    public UnificationEntry<class_1792> findPriorityOverrideItem(class_6862<class_1792> tag, List<UnificationEntry<class_1792>> items) {
        String priorityOverride = getPriorityOverride(tag);
        if (priorityOverride == null) return null;

        var entry = findItemByNamespace(items, priorityOverride);
        if (entry != null) return entry;

        AlmostUnifiedCommon.LOGGER.warn(
            "Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.",
            priorityOverride,
            tag.comp_327()
        );
        return null;
    }

    @Nullable
    @Override
    public UnificationEntry<class_1792> findTargetItem(class_6862<class_1792> tag, List<UnificationEntry<class_1792>> items) {
        var overrideEntry = findPriorityOverrideItem(tag, items);
        if (overrideEntry != null) {
            return overrideEntry;
        }

        for (String modPriority : modPriorities) {
            var entry = findItemByNamespace(items, modPriority);
            if (entry != null) return entry;
        }

        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return modPriorities.iterator();
    }

    @Nullable
    private static UnificationEntry<class_1792> findItemByNamespace(List<UnificationEntry<class_1792>> items, String namespace) {
        for (var item : items) {
            if (item.id().method_12836().equals(namespace)) {
                return item;
            }
        }

        return null;
    }
}
