package com.almostreliable.unified.core;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnified;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.UnificationEntry;

import com.google.auto.service.AutoService;

import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

@AutoService(AlmostUnified.class)
public class AlmostUnifiedImpl implements AlmostUnified {

    @Override
    public boolean isRuntimeLoaded() {
        return getRuntime() != null;
    }

    @Nullable
    @Override
    public AlmostUnifiedRuntime getRuntime() {
        return AlmostUnifiedCommon.getRuntime();
    }

    @Override
    public AlmostUnifiedRuntime getRuntimeOrThrow() {
        AlmostUnifiedRuntime runtime = AlmostUnifiedCommon.getRuntime();
        if (runtime == null) {
            throw new IllegalStateException("runtime is not loaded");
        }

        return runtime;
    }

    @Override
    public Collection<class_6862<class_1792>> getTags() {
        if (!isRuntimeLoaded()) return Set.of();
        return getRuntimeOrThrow().getUnificationLookup().getTags();
    }

    @Override
    public Collection<class_1792> getTagEntries(class_6862<class_1792> tag) {
        if (!isRuntimeLoaded()) return Set.of();
        return getRuntimeOrThrow()
            .getUnificationLookup()
            .getTagEntries(tag)
            .stream()
            .map(UnificationEntry::value)
            .collect(Collectors.toSet());
    }

    @Nullable
    @Override
    public class_6862<class_1792> getRelevantItemTag(class_1935 itemLike) {
        if (!isRuntimeLoaded()) return null;
        return getRuntimeOrThrow().getUnificationLookup().getRelevantItemTag(itemLike.method_8389());
    }

    @Nullable
    @Override
    public class_1792 getVariantItemTarget(class_1935 itemLike) {
        if (!isRuntimeLoaded()) return null;

        class_2960 id = class_7923.field_41178.method_10221(itemLike.method_8389());
        var replacement = getRuntimeOrThrow().getUnificationLookup().getVariantItemTarget(id);
        return replacement == null ? null : replacement.value();
    }

    @Nullable
    @Override
    public class_1792 getTagTargetItem(class_6862<class_1792> tag) {
        if (!isRuntimeLoaded()) return null;

        var replacement = getRuntimeOrThrow().getUnificationLookup().getTagTargetItem(tag);
        return replacement == null ? null : replacement.value();
    }
}
