package com.almostreliable.unified;

import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.StartupConfig;
import com.almostreliable.unified.core.AlmostUnifiedRuntimeImpl;
import com.almostreliable.unified.unification.loot.LootUnification;
import com.almostreliable.unified.utils.CustomLogger;
import com.almostreliable.unified.utils.VanillaTagWrapper;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import org.apache.logging.log4j.Logger;

import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

@SuppressWarnings({ "UtilityClassWithoutPrivateConstructor", "StaticVariableUsedBeforeInitialization" })
public final class AlmostUnifiedCommon {

    public static final Logger LOGGER = CustomLogger.create();
    public static final StartupConfig STARTUP_CONFIG = Config.load(StartupConfig.NAME, StartupConfig.SERIALIZER);

    @Nullable private static AlmostUnifiedRuntimeImpl RUNTIME;

    @Nullable
    public static AlmostUnifiedRuntime getRuntime() {
        return RUNTIME;
    }

    public static void onTagLoaderReload(VanillaTagWrapper<class_1792> itemTags, VanillaTagWrapper<class_2248> blockTags) {
        RUNTIME = AlmostUnifiedRuntimeImpl.create(itemTags, blockTags);
    }

    public static void onRecipeManagerReload(Map<class_2960, JsonElement> recipes, class_7225.class_7874 registries, class_1863 recipeManager) {
        Preconditions.checkNotNull(RUNTIME, "runtime was not loaded correctly");

        RUNTIME.run(recipes, recipeManager);
        LootUnification.unifyLoot(RUNTIME, registries);
    }

    public static void onRecipeManagerError(class_2960 recipe) {
        if (RUNTIME == null) return;
        RUNTIME.getDebugHandler().collectRecipeError(recipe);
    }

    public static void onRecipeManagerEnd() {
        if (RUNTIME == null) return;
        RUNTIME.getDebugHandler().finish();
    }
}
