package com.almostreliable.unified.api;

import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_6862;
import java.util.ServiceLoader;
import java.util.Set;

public interface AlmostUnifiedLookup {

    AlmostUnifiedLookup INSTANCE = ServiceLoader.load(AlmostUnifiedLookup.class).findFirst().orElseGet(Empty::new);

    boolean isLoaded();

    /**
     * Returns the replacement item for a given {@link class_1935}. Will return null if no configured
     * tag exists that includes the item.
     * <p>
     * If the item is part of some stone strata, it will only check items within the same stone strata.<br>
     * => e.g. "modid:deepslate_foo_ore" would not return "prio_modid:foo_ore".
     *
     * @param itemLike The item-like to find the replacement for
     * @return The replacement item or null if there is no replacement
     */
    @Nullable
    class_1792 getReplacementForItem(class_1935 itemLike);

    /**
     * Returns the preferred item for a given {@link class_6862}. Will return null if no configured
     * tag exists that includes the item.
     * <p>
     * The preferred item is selected according to mod priorities, but it's possible to set a
     * fixed override in the config.
     *
     * @param tag The tag to find the preferred item for
     * @return The preferred item or null if there is no preferred item
     */
    @Nullable
    class_1792 getPreferredItemForTag(class_6862<class_1792> tag);

    /**
     * Returns the preferred tag for a given {@link class_1935} Will return null if no configured
     * tag exists that includes the item.
     *
     * @param itemLike The item-like to find the preferred tag for
     * @return The preferred tag or null if there is no preferred tag
     */
    @Nullable
    class_6862<class_1792> getPreferredTagForItem(class_1935 itemLike);

    /**
     * Returns all potential items which are part of a given tag.
     * <p>
     * Tags are only considered if they are part of the config,
     * otherwise, an empty set is always returned.
     *
     * @param tag The tag to find the potential items for
     * @return The potential items or an empty set if there are no potential items
     */
    Set<class_1792> getPotentialItems(class_6862<class_1792> tag);

    /**
     * Returns all configured tags.
     *
     * @return The configured tags
     */
    Set<class_6862<class_1792>> getConfiguredTags();

    class Empty implements AlmostUnifiedLookup {

        @Override
        public boolean isLoaded() {
            return false;
        }

        @Nullable
        @Override
        public class_1792 getReplacementForItem(class_1935 itemLike) {
            return null;
        }

        @Nullable
        @Override
        public class_1792 getPreferredItemForTag(class_6862<class_1792> tag) {
            return null;
        }

        @Nullable
        @Override
        public class_6862<class_1792> getPreferredTagForItem(class_1935 itemLike) {
            return null;
        }

        @Override
        public Set<class_1792> getPotentialItems(class_6862<class_1792> tag) {
            return Set.of();
        }

        @Override
        public Set<class_6862<class_1792>> getConfiguredTags() {
            return Set.of();
        }
    }
}
