/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.utils.FileUtils;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class DebugConfig
extends Config {
    public static final String NAME = "debug";
    public final boolean dumpTagMap;
    public final boolean dumpDuplicates;
    public final boolean dumpUnification;
    public final boolean dumpOverview;
    public final boolean dumpRecipes;
    public final boolean dumpUncoveredRecipes;

    public DebugConfig(boolean dumpTagMap, boolean dumpDuplicates, boolean dumpUnification, boolean dumpOverview, boolean dumpRecipes, boolean dumpUncoveredRecipes) {
        this.dumpTagMap = dumpTagMap;
        this.dumpDuplicates = dumpDuplicates;
        this.dumpUnification = dumpUnification;
        this.dumpOverview = dumpOverview;
        this.dumpRecipes = dumpRecipes;
        this.dumpUncoveredRecipes = dumpUncoveredRecipes;
    }

    public void logUnifyTagDump(TagMap<class_1792> tagMap) {
        if (!this.dumpTagMap) {
            return;
        }
        FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), "unify_tag_dump.txt", sb -> sb.append(tagMap.getTags().stream().sorted(Comparator.comparing(t -> t.location().toString())).map(t -> StringUtils.rightPad((String)t.location().toString(), (int)40) + " => " + tagMap.getEntriesByTag((UnifyTag<class_1792>)t).stream().map(class_2960::toString).sorted().collect(Collectors.joining(", ")) + "\n").collect(Collectors.joining())));
    }

    public void logRecipes(Map<class_2960, JsonElement> recipes, String filename) {
        if (!this.dumpRecipes) {
            return;
        }
        FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getLogPath(), filename, sb -> recipes.forEach((key, value) -> sb.append(key.toString()).append(" [JSON]:").append(value.toString()).append("\n")));
    }

    public static class Serializer
    extends Config.Serializer<DebugConfig> {
        public static final String DUMP_TAG_MAP = "dumpTagMap";
        public static final String DUMP_DUPLICATES = "dumpDuplicates";
        public static final String DUMP_UNIFICATION = "dumpUnification";
        public static final String DUMP_OVERVIEW = "dumpOverview";
        public static final String DUMP_RECIPES = "dumpRecipes";
        public static final String DUMP_UNCOVERED_RECIPES = "dumpUncoveredRecipes";

        @Override
        public DebugConfig deserialize(JsonObject json) {
            return new DebugConfig(this.safeGet(() -> json.get(DUMP_TAG_MAP).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_DUPLICATES).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_UNIFICATION).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_OVERVIEW).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_RECIPES).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_UNCOVERED_RECIPES).getAsBoolean(), false));
        }

        @Override
        public JsonObject serialize(DebugConfig src) {
            JsonObject json = new JsonObject();
            json.addProperty(DUMP_TAG_MAP, Boolean.valueOf(src.dumpTagMap));
            json.addProperty(DUMP_DUPLICATES, Boolean.valueOf(src.dumpDuplicates));
            json.addProperty(DUMP_UNIFICATION, Boolean.valueOf(src.dumpUnification));
            json.addProperty(DUMP_OVERVIEW, Boolean.valueOf(src.dumpOverview));
            json.addProperty(DUMP_RECIPES, Boolean.valueOf(src.dumpRecipes));
            json.addProperty(DUMP_UNCOVERED_RECIPES, Boolean.valueOf(src.dumpUncoveredRecipes));
            return json;
        }
    }
}

