package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.*;
import net.minecraft.class_2960;

public class RecipeTypePropertiesLogger {
    private final Map<String, List<String>> properties = new HashMap<>();

    private List<String> getProperties(String mod) {
        return properties.computeIfAbsent(mod, $ -> new ArrayList<>());
    }

    public void log(class_2960 recipeType, JsonObject recipe, Collection<String> keys) {
        String mod = recipeType.method_12836();
        recipe.entrySet().forEach(e -> getProperties(mod).add(e.getKey()));
    }

    public void log(String mod, String property) {
        getProperties(mod).add(property);
    }

    public void writeFile() {
        StringBuilder sb = new StringBuilder();
        properties.forEach((mod, props) -> {
            sb.append(mod).append(":\n");
            props.sort(String::compareTo);
            props.forEach(property -> sb.append("    ").append(property).append("\n"));
        });

        Path path = AlmostUnifiedPlatform.INSTANCE.getLogPath();
        FileUtils.write(path, "debug_recipe_properties.txt", stringBuilder -> sb.append(sb));
    }
}
