package com.almostreliable.unified.mixin.runtime;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.utils.TagReloadHandler;
import com.almostreliable.unified.utils.Utils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3503;
import net.minecraft.class_6880;

@Mixin(class_3503.class)
public class TagLoaderMixin {

    @Shadow @Final private String directory;

    @Inject(method = "build(Ljava/util/Map;)Ljava/util/Map;", at = @At("RETURN"))
    private <T> void onCreateLoadResult(Map<class_2960, List<class_3503.class_5145>> map, CallbackInfoReturnable<Map<class_2960, Collection<T>>> cir) {
        if (directory.equals("tags/items")) {
            try {
                Map<class_2960, Collection<class_6880<class_1792>>> tags = Utils.cast(cir.getReturnValue());
                TagReloadHandler.initItemTags(tags);
                TagReloadHandler.run();
            } catch (Exception e) {
                AlmostUnified.LOG.error(e.getMessage(), e);
            }
        }
        if (directory.equals("tags/blocks")) {
            try {
                Map<class_2960, Collection<class_6880<class_2248>>> tags = Utils.cast(cir.getReturnValue());
                TagReloadHandler.initBlockTags(tags);
                TagReloadHandler.run();
            } catch (Exception e) {
                AlmostUnified.LOG.error(e.getMessage(), e);
            }
        }
    }
}
