package com.almostreliable.unified;

import com.almostreliable.unified.api.AlmostUnifiedLookup;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.auto.service.AutoService;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.Set;
import java.util.stream.Collectors;

@AutoService(AlmostUnifiedLookup.class)
public class AlmostUnifiedLookupImpl implements AlmostUnifiedLookup {

    @Override
    public boolean isLoaded() {
        return AlmostUnified.isRuntimeLoaded();
    }

    @Nullable
    @Override
    public class_1792 getReplacementForItem(class_1935 itemLike) {
        class_2960 id = class_7923.field_41178.method_10221(itemLike.method_8389());
        return AlmostUnified
                .getRuntime()
                .getReplacementMap()
                .map(rm -> rm.getReplacementForItem(id))
                .flatMap(class_7923.field_41178::method_17966)
                .orElse(null);
    }

    @Nullable
    @Override
    public class_1792 getPreferredItemForTag(class_6862<class_1792> tag) {
        UnifyTag<class_1792> asUnifyTag = UnifyTag.item(tag.comp_327());
        return AlmostUnified
                .getRuntime()
                .getReplacementMap()
                .map(rm -> rm.getPreferredItemForTag(asUnifyTag, $ -> true))
                .flatMap(class_7923.field_41178::method_17966)
                .orElse(null);
    }

    @Nullable
    @Override
    public class_6862<class_1792> getPreferredTagForItem(class_1935 itemLike) {
        class_2960 id = class_7923.field_41178.method_10221(itemLike.method_8389());
        return AlmostUnified
                .getRuntime()
                .getReplacementMap()
                .map(rm -> rm.getPreferredTagForItem(id))
                .map(ut -> class_6862.method_40092(class_7924.field_41197, ut.location()))
                .orElse(null);
    }

    @Override
    public Set<class_1792> getPotentialItems(class_6862<class_1792> tag) {
        UnifyTag<class_1792> asUnifyTag = UnifyTag.item(tag.comp_327());
        return AlmostUnified
                .getRuntime()
                .getFilteredTagMap()
                .map(tagMap -> tagMap
                        .getEntriesByTag(asUnifyTag)
                        .stream()
                        .flatMap(rl -> class_7923.field_41178.method_17966(rl).stream())
                        .collect(Collectors.toSet()))
                .orElseGet(Set::of);
    }

    @Override
    public Set<class_6862<class_1792>> getConfiguredTags() {
        return AlmostUnified
                .getRuntime()
                .getFilteredTagMap()
                .map(tagMap -> tagMap
                        .getTags()
                        .stream()
                        .map(ut -> class_6862.method_40092(class_7924.field_41197, ut.location()))
                        .collect(Collectors.toSet()))
                .orElseGet(Set::of);
    }
}
