/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_morph.identity.rendering;

import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import draylar.identity.api.variant.TypeProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class ColorVariantProvider<CV extends LivingEntity>
extends TypeProvider<CV> {
    public static final Map<EntityType<?>, List<String>> validColors = new ConcurrentHashMap();

    protected abstract void setColor(CV var1, String var2);

    public int getVariantData(CV cv) {
        List colors = validColors.getOrDefault(cv.getType(), null);
        if (colors != null) {
            return colors.indexOf(((ICharmSerializable)cv).getColor().toLowerCase());
        }
        return -1;
    }

    public CV create(EntityType<CV> entityType, Level level, int i) {
        List colors;
        LivingEntity summon = (LivingEntity)entityType.create(level);
        if (summon == null) {
            return null;
        }
        if (i >= 0 && (colors = (List)validColors.getOrDefault(entityType, null)) != null && i < colors.size()) {
            this.setColor(summon, (String)colors.get(i));
        }
        return (CV)summon;
    }

    public int getFallbackData() {
        return 0;
    }

    public int getRange() {
        return 16;
    }

    public Component modifyText(CV entity, MutableComponent mutableComponent) {
        return mutableComponent.append(" " + ((ICharmSerializable)entity).getColor());
    }

    static {
        validColors.put((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get(), List.of(EntityWixie.COLORS));
        validColors.put((EntityType)ModEntities.ENTITY_DRYGMY.get(), List.of(EntityDrygmy.COLORS));
        validColors.put((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get(), List.of(EntityBookwyrm.COLORS));
        validColors.put((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), List.of(new String[]{"summer", "winter", "autumn", "spring"}));
    }
}

