/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_morph.identity.ability;

import com.alexthw.ars_morph.MorphConfig;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import draylar.identity.ability.IdentityAbility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WixieAbility
extends IdentityAbility<EntityWixie> {
    public static final ArrayList<Holder<MobEffect>> goodEffectTable = new ArrayList<Holder>(Arrays.asList(MobEffects.SATURATION, MobEffects.MOVEMENT_SPEED, MobEffects.DIG_SPEED, MobEffects.DAMAGE_BOOST, MobEffects.ABSORPTION, MobEffects.FIRE_RESISTANCE, MobEffects.REGENERATION, MobEffects.DOLPHINS_GRACE, ModPotions.MANA_REGEN_EFFECT, ModPotions.DEFENCE_EFFECT));
    public static final ArrayList<Holder<MobEffect>> badEffectTable = new ArrayList<Holder>(Arrays.asList(MobEffects.MOVEMENT_SLOWDOWN, MobEffects.WEAKNESS, MobEffects.LEVITATION, MobEffects.POISON, MobEffects.CONFUSION, MobEffects.BLINDNESS, MobEffects.DARKNESS, MobEffects.DIG_SLOWDOWN, MobEffects.HARM, ModPotions.FREEZING_EFFECT, ModPotions.BLAST_EFFECT, ModPotions.HEX_EFFECT));

    public void onUse(Player player, EntityWixie entityWixie, Level level) {
        Holder<MobEffect> effect = (player.isCrouching() ? goodEffectTable : badEffectTable).get(player.getRandom().nextInt(badEffectTable.size()));
        ThrownPotion thrownpotion = new ThrownPotion(level, (LivingEntity)player);
        ItemStack stckToThrow = this.getThrownStack(effect);
        thrownpotion.setItem(stckToThrow);
        thrownpotion.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
        level.addFreshEntity((Entity)thrownpotion);
    }

    private ItemStack getThrownStack(Holder<MobEffect> effect) {
        ItemStack splashStack = new ItemStack((ItemLike)Items.SPLASH_POTION);
        splashStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.of(Potions.WATER), Optional.empty(), List.of(new MobEffectInstance(effect, 200, 1))));
        return splashStack;
    }

    public int getCooldown(EntityWixie entity) {
        return (Integer)MorphConfig.Common.WIXIE_COOLDOWN.get();
    }

    public Item getIcon() {
        return ItemsRegistry.WIXIE_CHARM.asItem();
    }
}

