/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_morph.identity.ability;

import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.registry.ModItems;
import com.alexthw.ars_morph.MorphConfig;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import draylar.identity.ability.IdentityAbility;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FirenandoAbility
extends IdentityAbility<FirenandoEntity> {
    private final ParticleColor color = new ParticleColor(250, 50, 15);
    private final ParticleColor colorAlt = new ParticleColor(15, 100, 200);

    public void onUse(Player player, FirenandoEntity firenandoEntity, Level level) {
        ParticleColor spellColor = firenandoEntity.getColor().equals(FirenandoEntity.Variants.MAGMA.toString()) ? this.color : this.colorAlt;
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(level, firenandoEntity.spell, (LivingEntity)player, (IWrappedCaster)new LivingCaster((LivingEntity)player)).withColors(spellColor));
        if (resolver.postEvent().isCanceled()) {
            return;
        }
        EntityHomingProjectileSpell projectileSpell = new EntityHomingProjectileSpell(level, (SpellResolver)resolver);
        List ignore = MethodHomingProjectile.basicIgnores((LivingEntity)player, (Boolean)false, (Spell)resolver.spell);
        ignore.add(entity -> !(entity instanceof Enemy));
        projectileSpell.shoot((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.8f, 0.8f);
        projectileSpell.setIgnored(ignore);
        level.addFreshEntity((Entity)projectileSpell);
    }

    public int getCooldown(FirenandoEntity entity) {
        return (Integer)MorphConfig.Common.FLARE_COOLDOWN.get();
    }

    public Item getIcon() {
        return (Item)ModItems.FIRENANDO_CHARM.get();
    }
}

