/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_morph.identity;

import com.alexthw.ars_morph.identity.ElementalModule;
import com.alexthw.ars_morph.identity.ability.StarbuncleAbility;
import com.alexthw.ars_morph.identity.ability.WealdWalkerAbility;
import com.alexthw.ars_morph.identity.ability.WhirlisprigAbility;
import com.alexthw.ars_morph.identity.ability.WildenHunterAbility;
import com.alexthw.ars_morph.identity.ability.WildenStalkerAbility;
import com.alexthw.ars_morph.identity.ability.WixieAbility;
import com.alexthw.ars_morph.identity.rendering.ColorVariantProvider;
import com.alexthw.ars_morph.identity.rendering.StarbuncleTypeProvider;
import com.alexthw.ars_morph.identity.tick_handlers.StalkerTickHandler;
import com.alexthw.ars_morph.identity.tick_handlers.WhirlSprigTickHandler;
import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import draylar.identity.ability.AbilityRegistry;
import draylar.identity.ability.IdentityAbility;
import draylar.identity.api.IdentityTickHandler;
import draylar.identity.api.IdentityTickHandlers;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.api.variant.TypeProvider;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class IdentityReg {
    public static DeferredHolder<MobEffect, MobEffect> MORPH;

    public static void preInit() {
        NeoForge.EVENT_BUS.register(IdentityReg.class);
    }

    public static void postInit() {
        Map variants = (Map)ObfuscationReflectionHelper.getPrivateValue(IdentityType.class, (Object)new IdentityType(null, 0), (String)"VARIANT_BY_TYPE");
        IdentityReg.initAbilities();
        if (variants != null) {
            IdentityReg.initVariants(variants);
        }
    }

    private static void initVariants(Map<EntityType<? extends LivingEntity>, TypeProvider<?>> variants) {
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), new StarbuncleTypeProvider());
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), new ColorVariantProvider<Whirlisprig>(){

            @Override
            protected void setColor(Whirlisprig whirlisprig, String color) {
                whirlisprig.getEntityData().set(Whirlisprig.COLOR, (Object)color);
            }

            @Override
            public int getRange() {
                return 3;
            }
        });
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_DRYGMY.get()), new ColorVariantProvider<EntityDrygmy>(){

            @Override
            protected void setColor(EntityDrygmy drygmy, String color) {
                drygmy.getEntityData().set(EntityDrygmy.COLOR, (Object)color);
            }

            @Override
            public int getRange() {
                return EntityDrygmy.COLORS.length - 1;
            }
        });
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_BOOKWYRM_TYPE.get()), new ColorVariantProvider<EntityBookwyrm>(){

            @Override
            protected void setColor(EntityBookwyrm bookwyrm, String color) {
                bookwyrm.setColor(color);
            }

            @Override
            public int getRange() {
                return EntityBookwyrm.COLORS.length - 1;
            }
        });
        variants.put((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), new ColorVariantProvider<EntityWixie>(){

            @Override
            protected void setColor(EntityWixie entityWixie, String color) {
                entityWixie.getEntityData().set(EntityWixie.COLOR, (Object)color);
            }

            @Override
            public int getRange() {
                return EntityWixie.COLORS.length - 1;
            }
        });
        if (ModList.get().isLoaded("ars_elemental")) {
            ElementalModule.variants(variants);
        }
    }

    public static void initAbilities() {
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_BLAZING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_CASCADING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_FLOURISHING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_VEXING_WEALD.get()), new WealdWalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.WILDEN_HUNTER.get()), (IdentityAbility)new WildenHunterAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.WILDEN_STALKER.get()), (IdentityAbility)new WildenStalkerAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.STARBUNCLE_TYPE.get()), new StarbuncleAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), new WhirlisprigAbility());
        AbilityRegistry.register((EntityType)((EntityType)ModEntities.ENTITY_WIXIE_TYPE.get()), (IdentityAbility)new WixieAbility());
        IdentityTickHandlers.register((EntityType)((EntityType)ModEntities.WHIRLISPRIG_TYPE.get()), (IdentityTickHandler)new WhirlSprigTickHandler());
        IdentityTickHandlers.register((EntityType)((EntityType)ModEntities.WILDEN_STALKER.get()), (IdentityTickHandler)new StalkerTickHandler());
        if (ModList.get().isLoaded("ars_elemental")) {
            ElementalModule.initAbilities();
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(EntityInvulnerabilityCheckEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getSource() == player.damageSources().sweetBerryBush() && PlayerIdentity.getIdentity((Player)player) instanceof Starbuncle) {
                event.setInvulnerable(true);
            }
        }
    }

    public static void morphInto(Level world, ServerPlayer player, LivingEntity living) {
        if (living == null) {
            PlayerIdentity.updateIdentity((ServerPlayer)player, null, null);
            return;
        }
        IdentityType type = IdentityType.from((LivingEntity)living);
        if (type != null) {
            LivingEntity morph = type.create(world);
            if (morph instanceof IDecoratable) {
                IDecoratable toDeco = (IDecoratable)morph;
                if (living instanceof IDecoratable) {
                    IDecoratable fromDeco = (IDecoratable)living;
                    toDeco.setCosmeticItem(fromDeco.getCosmeticItem());
                }
            }
            PlayerIdentity.updateIdentity((ServerPlayer)player, (IdentityType)type, (LivingEntity)morph);
        }
    }
}

