/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_morph.glyphs;

import com.alexthw.ars_morph.ArsMorph;
import com.alexthw.ars_morph.identity.IdentityReg;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class MorphEffect
extends AbstractEffect {
    public static MorphEffect INSTANCE = new MorphEffect(ArsMorph.prefix("glyph_morph"), "Morph");

    public MorphEffect(ResourceLocation tag, String description) {
        super(tag, description);
    }

    public int getDefaultManaCost() {
        return 100;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (shooter instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)shooter;
                IdentityReg.morphInto(world, player, living);
            }
        }
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getSummonAugments();
    }
}

