/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.ars_morph.datagen;

import com.alexthw.ars_morph.glyphs.MorphEffect;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.datagen.GlyphRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ArsProviders {
    static String root = "ars_morph";

    public static class GlyphProvider
    extends GlyphRecipeProvider {
        public GlyphProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            this.recipes.add(this.get((AbstractSpellPart)MorphEffect.INSTANCE).withItem((ItemLike)Items.DIRT));
            for (GlyphRecipe recipe : this.recipes) {
                Path path = GlyphProvider.getScribeGlyphPath(output, recipe.output.getItem());
                this.saveStable(cache, (JsonElement)GlyphRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).getOrThrow(), path);
            }
        }

        protected static Path getScribeGlyphPath(Path pathIn, Item glyph) {
            return pathIn.resolve("data/" + root + "/recipe/" + RegistryHelper.getRegistryName((Item)glyph).getPath() + ".json");
        }

        @NotNull
        public String getName() {
            return "Ars Morph Glyph Recipes";
        }
    }
}

