package com.alexthw.ars_morph.identity.rendering;

import com.hollingsworth.arsnouveau.common.entity.EntityBookwyrm;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import draylar.identity.api.variant.TypeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressWarnings("ALL")
public abstract class ColorVariantProvider<CV extends LivingEntity & ICharmSerializable> extends TypeProvider<CV> {

    abstract protected void setColor(CV cv, String color);

    @Override
    public int getVariantData(CV cv) {
        List<String> colors = validColors.getOrDefault(cv.getType(), null);
        if (colors != null) {
            return colors.indexOf(cv.getColor().toLowerCase());
        }
        return -1;
    }

    @Override
    public CV create(EntityType<CV> entityType, Level level, int i) {
        CV summon = entityType.create(level);
        if (summon == null) return null;
        if (i >= 0) {
            List<String> colors = validColors.getOrDefault(entityType, null);
            if (colors != null && i < colors.size())
                setColor(summon,colors.get(i));
        }
        return summon;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return 16;
    }

    @Override
    public Component modifyText(CV entity, MutableComponent mutableComponent) {
        return mutableComponent.append(" " + entity.getColor());
    }

    public static final Map<EntityType<?>, List<String>> validColors = new ConcurrentHashMap<>();

    static {
        validColors.put(ModEntities.ENTITY_WIXIE_TYPE.get(), List.of(EntityWixie.COLORS));
        validColors.put(ModEntities.ENTITY_DRYGMY.get(), List.of(EntityDrygmy.COLORS));
        validColors.put(ModEntities.ENTITY_BOOKWYRM_TYPE.get(), List.of(EntityBookwyrm.COLORS));
        validColors.put(ModEntities.WHIRLISPRIG_TYPE.get(), List.of(new String[]{"summer", "winter", "autumn", "spring"}));
    }

}
