/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSkyhookSync
implements IMessage {
    int entityID;
    ImmersiveNetHandler.Connection connection;
    BlockPos target;
    Vec3d[] subPoints;
    int targetPoint;

    public MessageSkyhookSync(EntitySkylineHook entity) {
        this.entityID = entity.func_145782_y();
        this.connection = entity.connection;
        this.target = entity.target;
        this.subPoints = entity.subPoints;
        this.targetPoint = entity.targetPoint;
    }

    public MessageSkyhookSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.connection = ImmersiveNetHandler.Connection.readFromNBT(tag);
        this.target = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int l = buf.readInt();
        this.subPoints = new Vec3d[l];
        for (int i = 0; i < l; ++i) {
            this.subPoints[i] = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        this.targetPoint = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.connection.writeToNBT());
        buf.writeInt(this.target.func_177958_n()).writeInt(this.target.func_177956_o()).writeInt(this.target.func_177952_p());
        buf.writeInt(this.subPoints.length);
        for (Vec3d v : this.subPoints) {
            buf.writeDouble(v.field_72450_a);
            buf.writeDouble(v.field_72448_b);
            buf.writeDouble(v.field_72449_c);
        }
        buf.writeInt(this.targetPoint);
    }

    public static class Handler
    implements IMessageHandler<MessageSkyhookSync, IMessage> {
        public IMessage onMessage(MessageSkyhookSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Entity ent;
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (ent = world.func_73045_a(message.entityID)) instanceof EntitySkylineHook) {
                    ((EntitySkylineHook)ent).connection = message.connection;
                    ((EntitySkylineHook)ent).target = message.target;
                    ((EntitySkylineHook)ent).subPoints = message.subPoints;
                    ((EntitySkylineHook)ent).targetPoint = message.targetPoint;
                }
            });
            return null;
        }
    }
}

