/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageShaderManual
implements IMessage {
    MessageType key;
    String[] args;

    public MessageShaderManual(MessageType key, String ... args) {
        this.key = key;
        this.args = args;
    }

    public MessageShaderManual() {
    }

    public void fromBytes(ByteBuf buf) {
        this.key = MessageType.values()[buf.readInt()];
        int l = buf.readInt();
        this.args = new String[l];
        for (int i = 0; i < l; ++i) {
            this.args[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.key.ordinal());
        if (this.args != null) {
            buf.writeInt(this.args.length);
            for (String s : this.args) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static class HandlerClient
    implements IMessageHandler<MessageShaderManual, IMessage> {
        public IMessage onMessage(MessageShaderManual message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayerSP player;
                if (message.key == MessageType.SYNC && (player = ClientUtils.mc().field_71439_g) != null) {
                    String name = player.func_70005_c_();
                    for (String shader : message.args) {
                        if (shader == null) continue;
                        ShaderRegistry.receivedShaders.put((Object)name, (Object)shader);
                    }
                }
            });
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<MessageShaderManual, IMessage> {
        public IMessage onMessage(MessageShaderManual message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            String playerName = player.func_70005_c_();
            player.func_71121_q().func_152344_a(() -> {
                if (message.key == MessageType.SYNC) {
                    List received = ShaderRegistry.receivedShaders.get((Object)playerName);
                    String[] ss = received.toArray(new String[received.size()]);
                    ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageShaderManual(MessageType.SYNC, ss), player);
                } else if (message.key == MessageType.UNLOCK && message.args.length > 0) {
                    ShaderRegistry.receivedShaders.put((Object)playerName, (Object)message.args[0]);
                } else if (message.key == MessageType.SPAWN && message.args.length > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        ApiUtils.consumePlayerIngredient((EntityPlayer)player, ShaderRegistry.shaderRegistry.get((Object)playerName).replicationCost);
                    }
                    ItemStack shaderStack = new ItemStack(ShaderRegistry.itemShader);
                    ItemNBTHelper.setString(shaderStack, "shader_name", message.args[0]);
                    EntityItem entityitem = player.func_71019_a(shaderStack, false);
                    if (entityitem != null) {
                        entityitem.func_174868_q();
                        entityitem.func_145797_a(player.func_70005_c_());
                    }
                }
            });
            return null;
        }
    }

    public static enum MessageType {
        SYNC,
        UNLOCK,
        SPAWN;

    }
}

