/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Mixer")
public class Mixer {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack fluidInput, IIngredient[] itemInputs, int energy) {
        Object[] adds = null;
        if (itemInputs != null) {
            adds = new Object[itemInputs.length];
            for (int i = 0; i < itemInputs.length; ++i) {
                adds[i] = CraftTweakerHelper.toObject(itemInputs[i]);
            }
        }
        MixerRecipe r = new MixerRecipe(CraftTweakerHelper.toFluidStack(output), CraftTweakerHelper.toFluidStack(fluidInput), adds, energy);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        if (CraftTweakerHelper.toFluidStack(output) != null) {
            CraftTweakerAPI.apply((IAction)new RemoveFluid(CraftTweakerHelper.toFluidStack(output)));
        }
    }

    private static class RemoveFluid
    implements IAction {
        private final FluidStack output;
        ArrayList<MixerRecipe> removedRecipes = new ArrayList();

        public RemoveFluid(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<MixerRecipe> it = MixerRecipe.recipeList.iterator();
            while (it.hasNext()) {
                MixerRecipe r = it.next();
                if (r == null || r.fluidOutput == null || !r.fluidOutput.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public String describe() {
            return "Removing Mixer Recipes for Fluid " + this.output.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        private final MixerRecipe recipe;

        public Add(MixerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MixerRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Fermenter Recipe for Fluid " + this.recipe.fluidOutput.getLocalizedName();
        }
    }
}

