/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEArmorBase;
import blusunrize.immersiveengineering.common.items.ItemPowerpack;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.Vec3d;

public class ModelPowerpack
extends ModelIEArmorBase {
    public ModelRenderer[] modelParts = new ModelRenderer[8];
    public ModelRenderer[] colouredParts = new ModelRenderer[4];
    static final DecimalFormat keyFormat = new DecimalFormat("0.0000");
    public static final Cache<String, Vec3d[]> catenaryCacheLeft = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<String, Vec3d[]> catenaryCacheRight = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    static ModelPowerpack modelInstance;

    public ModelPowerpack(float modelSize, float p_i1149_2_, int textureWidthIn, int textureHeightIn) {
        super(modelSize, p_i1149_2_, textureWidthIn, textureHeightIn);
        this.modelParts[0] = new ModelRenderer((ModelBase)this, 40, 0);
        this.modelParts[0].func_78790_a(-4.0f, -5.0f, -2.0f, 8, 10, 3, 0.0f);
        this.modelParts[0].func_78793_a(0.0f, 5.0f, 4.0f);
        this.field_78115_e.func_78792_a(this.modelParts[0]);
        this.modelParts[1] = new ModelRenderer((ModelBase)this, 12, 0);
        this.modelParts[1].func_78790_a(-3.0f, -2.0f, -2.0f, 6, 4, 4, 0.0f);
        this.modelParts[1].func_78793_a(0.0f, 12.0f, 4.0f);
        this.field_78115_e.func_78792_a(this.modelParts[1]);
        this.modelParts[2] = new ModelRenderer((ModelBase)this, 0, 0);
        this.modelParts[2].func_78790_a(-1.0f, -4.0f, -1.0f, 2, 8, 2, 0.0f);
        this.modelParts[2].func_78793_a(-5.0f, 5.0f, 3.0f);
        this.field_78115_e.func_78792_a(this.modelParts[2]);
        this.modelParts[3] = new ModelRenderer((ModelBase)this, 0, 0);
        this.modelParts[3].func_78790_a(-1.0f, -4.0f, -1.0f, 2, 8, 2, 0.0f);
        this.modelParts[3].func_78793_a(5.0f, 5.0f, 3.0f);
        this.modelParts[3].field_78808_h = 3.14159f;
        this.field_78115_e.func_78792_a(this.modelParts[3]);
        ModelRenderer gauge = new ModelRenderer((ModelBase)this, 40, 13);
        gauge.func_78790_a(-0.5f, -1.5f, -0.5f, 1, 3, 1, 0.0f);
        gauge.func_78793_a(-3.0f, 5.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        gauge = new ModelRenderer((ModelBase)this, 40, 13);
        gauge.func_78790_a(-0.5f, -1.5f, -0.5f, 1, 3, 1, 0.0f);
        gauge.func_78793_a(1.0f, 5.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        gauge = new ModelRenderer((ModelBase)this, 44, 13);
        gauge.func_78790_a(-2.0f, -0.5f, -0.5f, 3, 1, 1, 0.0f);
        gauge.func_78793_a(-0.5f, 3.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        gauge = new ModelRenderer((ModelBase)this, 44, 13);
        gauge.func_78790_a(-2.0f, -0.5f, -0.5f, 3, 1, 1, 0.0f);
        gauge.func_78793_a(-0.5f, 7.5f, 5.0f);
        this.field_78115_e.func_78792_a(gauge);
        this.modelParts[7] = new ModelRenderer((ModelBase)this, 52, 14);
        this.modelParts[7].func_78790_a(-0.5f, -3.5f, -0.5f, 1, 4, 1, -0.25f);
        this.modelParts[7].func_78793_a(-1.0f, 7.625f, 5.0f);
        this.modelParts[7].field_78808_h = 0.7853975f;
        this.field_78115_e.func_78792_a(this.modelParts[7]);
        ModelRenderer connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.func_78790_a(-1.0f, -1.5f, -1.5f, 3, 3, 3, 0.0f);
        connector.func_78793_a(-4.5f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.func_78790_a(-1.0f, -1.5f, -1.5f, 3, 3, 3, -0.375f);
        connector.func_78793_a(-6.0f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 29, 9);
        connector.func_78790_a(-1.0f, -1.5f, -1.5f, 1, 3, 3, 0.0f);
        connector.func_78793_a(-6.25f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 12, 8);
        connector.func_78790_a(-0.5f, -1.0f, -1.0f, 2, 2, 2, 0.0f);
        connector.func_78793_a(-7.5f, 0.0f, 0.0f);
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.func_78790_a(-1.0f, -1.5f, -1.5f, 3, 3, 3, 0.0f);
        connector.func_78793_a(4.5f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.func_78790_a(-1.0f, -1.5f, -1.5f, 3, 3, 3, -0.375f);
        connector.func_78793_a(6.0f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 29, 9);
        connector.func_78790_a(-1.0f, -1.5f, -1.5f, 1, 3, 3, 0.0f);
        connector.func_78793_a(6.25f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        connector = new ModelRenderer((ModelBase)this, 12, 8);
        connector.func_78790_a(-0.5f, -1.0f, -1.0f, 2, 2, 2, 0.0f);
        connector.func_78793_a(7.5f, 0.0f, 0.0f);
        connector.field_78796_g = 3.14159f;
        this.modelParts[1].func_78792_a(connector);
        for (int i = 0; i < 3; ++i) {
            float pos = 3.125f - (float)i * 2.25f;
            ModelRenderer tube = new ModelRenderer((ModelBase)this, 56, 19);
            tube.func_78790_a(-1.0f, -1.0f, -1.0f, 2, 2, 2, -0.25f);
            tube.func_78793_a(pos, 1.0f, 5.0f);
            tube.field_78795_f = (float)Math.toRadians(-45.0);
            this.field_78115_e.func_78792_a(tube);
            ModelRenderer tube2 = new ModelRenderer((ModelBase)this, 52, 18);
            tube2.func_78790_a(-0.5f, -2.0f, -0.5f, 1, 3, 1, 0.0f);
            tube2.func_78793_a(0.0f, -0.5f, 0.0f);
            tube.func_78792_a(tube2);
            tube2 = new ModelRenderer((ModelBase)this, 56, 15);
            tube2.func_78790_a(-1.0f, -2.0f, -1.0f, 2, 2, 2, 0.0f);
            tube2.func_78793_a(0.0f, -0.75f, 0.0f);
            tube.func_78792_a(tube2);
            tube2 = new ModelRenderer((ModelBase)this, 56, 13);
            tube2.func_78790_a(-0.5f, -1.0f, -0.5f, 1, 1, 1, 0.0f);
            tube2.func_78793_a(0.0f, -2.25f, 0.0f);
            tube.func_78792_a(tube2);
            tube2 = new ModelRenderer((ModelBase)this, 56, 13);
            tube2.func_78790_a(-0.5f, -1.0f, -0.5f, 1, 1, 1, -0.25f);
            tube2.func_78793_a(0.0f, -3.0f, 0.0f);
            tube.func_78792_a(tube2);
        }
        this.field_78116_c.field_78807_k = true;
        this.field_178720_f.field_78807_k = true;
        this.field_178724_i.field_78807_k = true;
        this.field_178723_h.field_78807_k = true;
        this.field_178722_k.field_78807_k = true;
        this.field_178721_j.field_78807_k = true;
    }

    @Override
    public void func_78088_a(Entity entity, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float scale) {
        if (entity instanceof EntityLivingBase) {
            ItemStack chest = ((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.CHEST);
            float storage = 0.0f;
            if (!chest.func_190926_b() && chest.func_77973_b() instanceof ItemArmor) {
                if (!(chest.func_77973_b() instanceof ItemPowerpack)) {
                    chest = ItemNBTHelper.getItemStack(chest, "IE:Powerpack");
                }
                if (chest.func_77973_b() instanceof ItemPowerpack) {
                    float max = EnergyHelper.getMaxEnergyStored(chest);
                    storage = max <= 0.0f ? 0.0f : (float)EnergyHelper.getEnergyStored(chest) / max;
                }
                this.modelParts[7].field_78808_h = 0.5235987f - 1.047197f * storage;
            }
        }
        GlStateManager.func_179147_l();
        super.func_78088_a(entity, p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, scale);
        GlStateManager.func_179084_k();
        ClientUtils.bindTexture("immersiveengineering:textures/blocks/wire.png");
        GlStateManager.func_179094_E();
        if (entity instanceof EntityLivingBase) {
            for (EnumHand hand : EnumHand.values()) {
                ItemStack stack = ((EntityLivingBase)entity).func_184586_b(hand);
                if (stack.func_190926_b() || !EnergyHelper.isFluxItem(stack)) continue;
                boolean right = hand == EnumHand.MAIN_HAND == (((EntityLivingBase)entity).func_184591_cq() == EnumHandSide.RIGHT);
                float angleX = (right ? this.field_178723_h : this.field_178724_i).field_78795_f;
                float angleZ = (right ? this.field_178723_h : this.field_178724_i).field_78808_h;
                String cacheKey = keyFormat.format(angleX) + "_" + keyFormat.format(angleZ);
                Vec3d[] vex = new Vec3d[]{};
                try {
                    vex = (Vec3d[])(right ? catenaryCacheRight : catenaryCacheLeft).get((Object)cacheKey, () -> {
                        double armLength = 0.75;
                        double x = 0.3125 + (double)(right ? 1 : -1) * armLength * Math.sin(angleZ);
                        double y = armLength * Math.cos(angleX);
                        double z = armLength * Math.sin(angleX);
                        return ApiUtils.getConnectionCatenary(new Vec3d(0.484375, -0.75, 0.25), new Vec3d(x, -y, z), 1.5);
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float vStep = 1.0f / (float)vex.length;
                int i = 0;
                Tessellator tes = ClientUtils.tes();
                BufferBuilder worldrenderer = tes.func_178180_c();
                float[] colour = new float[]{0.93f, 0.63f, 0.27f, 1.0f};
                worldrenderer.func_181668_a(8, DefaultVertexFormats.field_181709_i);
                for (Vec3d v : vex) {
                    worldrenderer.func_181662_b((right ? -v.field_72450_a : v.field_72450_a) - 0.015625, -v.field_72448_b, v.field_72449_c).func_187315_a((double)(vStep * (float)i), 0.0).func_181666_a(colour[0], colour[1], colour[2], colour[3]).func_181675_d();
                    worldrenderer.func_181662_b((right ? -v.field_72450_a : v.field_72450_a) + 0.015625, -v.field_72448_b, v.field_72449_c).func_187315_a((double)(vStep * (float)i++), 1.0).func_181666_a(colour[0], colour[1], colour[2], colour[3]).func_181675_d();
                }
                tes.func_78381_a();
                worldrenderer.func_181668_a(8, DefaultVertexFormats.field_181709_i);
                i = 0;
                for (Vec3d v : vex) {
                    worldrenderer.func_181662_b(right ? -v.field_72450_a : v.field_72450_a, -v.field_72448_b - 0.015625, v.field_72449_c).func_187315_a((double)(vStep * (float)i), 0.0).func_181666_a(colour[0], colour[1], colour[2], colour[3]).func_181675_d();
                    worldrenderer.func_181662_b(right ? -v.field_72450_a : v.field_72450_a, -v.field_72448_b + 0.015625, v.field_72449_c).func_187315_a((double)(vStep * (float)i++), 1.0).func_181666_a(colour[0], colour[1], colour[2], colour[3]).func_181675_d();
                }
                tes.func_78381_a();
            }
        }
        GlStateManager.func_179121_F();
    }

    public static ModelPowerpack getModel() {
        if (modelInstance == null) {
            modelInstance = new ModelPowerpack(0.0625f, 0.0f, 64, 32);
        }
        return modelInstance;
    }
}

