/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.Utils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ImmersiveNetHandler {
    public static final ImmersiveNetHandler INSTANCE = new ImmersiveNetHandler();
    public final BlockPlaceListener LISTENER = new BlockPlaceListener();
    public Map<Integer, ConcurrentHashMap<BlockPos, Set<Connection>>> directConnections = new ConcurrentHashMap<Integer, ConcurrentHashMap<BlockPos, Set<Connection>>>();
    public TIntObjectMap<Map<BlockPos, Set<AbstractConnection>>> indirectConnections = new TIntObjectHashMap();
    public TIntObjectMap<Map<BlockPos, Set<AbstractConnection>>> indirectConnectionsIgnoreOut = new TIntObjectHashMap();
    public Map<Integer, HashMap<Connection, Integer>> transferPerTick = new HashMap<Integer, HashMap<Connection, Integer>>();
    public Map<DimensionBlockPos, IICProxy> proxies = new ConcurrentHashMap<DimensionBlockPos, IICProxy>();
    public IntHashMap<Map<BlockPos, BlockWireInfo>> blockWireMap = new IntHashMap();

    private ConcurrentHashMap<BlockPos, Set<Connection>> getMultimap(int dimension) {
        if (this.directConnections.get(dimension) == null) {
            ConcurrentHashMap mm = new ConcurrentHashMap();
            this.directConnections.put(dimension, mm);
        }
        return this.directConnections.get(dimension);
    }

    public HashMap<Connection, Integer> getTransferedRates(int dimension) {
        if (!this.transferPerTick.containsKey(dimension)) {
            this.transferPerTick.put(dimension, new HashMap());
        }
        return this.transferPerTick.get(dimension);
    }

    public void addConnection(World world, BlockPos node, BlockPos connection, int distance, WireType cableType) {
        this.addAndGetConnection(world, node, connection, distance, cableType);
    }

    public Connection addAndGetConnection(World world, BlockPos node, BlockPos connection, int distance, WireType cableType) {
        Connection conn = new Connection(node, connection, cableType, distance);
        this.addConnection(world, node, conn);
        this.addConnection(world, connection, new Connection(connection, node, cableType, distance));
        if (world.func_175667_e(node)) {
            world.func_175641_c(node, world.func_180495_p(node).func_177230_c(), -1, 0);
        }
        if (world.func_175667_e(connection)) {
            world.func_175641_c(connection, world.func_180495_p(connection).func_177230_c(), -1, 0);
        }
        return conn;
    }

    public void addConnection(World world, BlockPos node, Connection con) {
        this.addConnection(world.field_73011_w.getDimension(), node, con);
        this.resetCachedIndirectConnections(world, node);
    }

    public void addConnection(int world, BlockPos node, Connection con) {
        if (!this.getMultimap(world).containsKey(node)) {
            this.getMultimap(world).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world).get(node).add(con);
        IESaveData.setDirty(world);
    }

    public <T extends TileEntity> void onTEValidated(T te) {
        Set<Connection> conns = this.getConnections(te.func_145831_w(), te.func_174877_v());
        if (conns != null) {
            for (Connection con : conns) {
                this.addBlockData(te.func_145831_w(), con);
            }
        }
        this.resetCachedIndirectConnections(te.func_145831_w(), te.func_174877_v());
        this.setProxy(new DimensionBlockPos(te), null);
    }

    public void addBlockData(World world, Connection con) {
        Map mapForDim;
        int dimId = world.field_73011_w.getDimension();
        if (!this.blockWireMap.func_76037_b(dimId)) {
            this.blockWireMap.func_76038_a(dimId, new ConcurrentHashMap());
        }
        if ((mapForDim = (Map)this.blockWireMap.func_76041_a(dimId)) == null || !world.func_175667_e(con.end)) {
            return;
        }
        ApiUtils.raytraceAlongCatenary(con, world, p -> {
            if (!mapForDim.containsKey(p.getLeft())) {
                mapForDim.put(p.getLeft(), new BlockWireInfo());
            }
            if (((BlockWireInfo)mapForDim.get((Object)p.getLeft())).in.stream().noneMatch(c -> ((Connection)c.getLeft()).hasSameConnectors(con))) {
                ((BlockWireInfo)mapForDim.get((Object)p.getLeft())).in.add((Triple<Connection, Vec3d, Vec3d>)new ImmutableTriple((Object)con, p.getMiddle(), p.getRight()));
            }
            return false;
        }, p -> {
            if (!mapForDim.containsKey(p.getLeft())) {
                mapForDim.put(p.getLeft(), new BlockWireInfo());
            }
            if (((BlockWireInfo)mapForDim.get((Object)p.getLeft())).near.stream().noneMatch(c -> ((Connection)c.getLeft()).hasSameConnectors(con))) {
                ((BlockWireInfo)mapForDim.get((Object)p.getLeft())).near.add((Triple<Connection, Vec3d, Vec3d>)new ImmutableTriple((Object)con, p.getMiddle(), p.getRight()));
            }
        });
    }

    public void removeConnection(World world, Connection con) {
        this.removeConnection(world, con, ApiUtils.getVecForIICAt(world, con.start, con), ApiUtils.getVecForIICAt(world, con.end, con));
    }

    public void removeConnection(World world, Connection con, Vec3d vecStart, Vec3d vecEnd) {
        if (con == null || world == null) {
            return;
        }
        int dim = world.field_73011_w.getDimension();
        this.resetCachedIndirectConnections(world, con.start);
        ConcurrentHashMap<BlockPos, Set<Connection>> connsInDim = this.getMultimap(world.field_73011_w.getDimension());
        Set reverseConns = (Set)connsInDim.get(con.end);
        Set forwardConns = (Set)connsInDim.get(con.start);
        Optional<Connection> back = reverseConns.stream().filter(con::hasSameConnectors).findAny();
        reverseConns.removeIf(con::hasSameConnectors);
        forwardConns.removeIf(con::hasSameConnectors);
        Map mapForDim = (Map)this.blockWireMap.func_76041_a(world.field_73011_w.getDimension());
        BiConsumer<BlockPos, Map> handle = (p, map) -> {
            BlockWireInfo info;
            if (mapForDim != null && (info = (BlockWireInfo)map.get(p)) != null) {
                for (int i = 0; i < 2; ++i) {
                    Set<Triple<Connection, Vec3d, Vec3d>> s = i == 0 ? info.in : info.near;
                    s.removeIf(t -> ((Connection)t.getLeft()).hasSameConnectors(con));
                    if (!s.isEmpty()) continue;
                    map.remove(p);
                }
                if (info.near.isEmpty() && info.in.isEmpty()) {
                    map.remove(p);
                }
            }
        };
        ApiUtils.raytraceAlongCatenaryRelative(con, p -> {
            handle.accept((BlockPos)p.getLeft(), mapForDim);
            return false;
        }, p -> handle.accept((BlockPos)p.getLeft(), mapForDim), vecStart, vecEnd);
        IImmersiveConnectable iic = ApiUtils.toIIC(con.end, world);
        if (iic != null) {
            iic.removeCable(con);
            back.ifPresent(iic::removeCable);
        }
        if ((iic = ApiUtils.toIIC(con.start, world)) != null) {
            iic.removeCable(con);
            back.ifPresent(iic::removeCable);
        }
        if (world.func_175667_e(con.start)) {
            world.func_175641_c(con.start, world.func_180495_p(con.start).func_177230_c(), -1, 0);
        }
        if (world.func_175667_e(con.end)) {
            world.func_175641_c(con.end, world.func_180495_p(con.end).func_177230_c(), -1, 0);
        }
        IESaveData.setDirty(dim);
    }

    public Set<Integer> getRelevantDimensions() {
        return this.directConnections.keySet();
    }

    public Collection<Connection> getAllConnections(int dimensionId) {
        Set<Connection> ret = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Set<Connection> conlist : this.getMultimap(dimensionId).values()) {
            ret.addAll(conlist);
        }
        return ret;
    }

    public Collection<Connection> getAllConnections(World world) {
        return this.getAllConnections(world.field_73011_w.getDimension());
    }

    @Nullable
    public synchronized Set<Connection> getConnections(World world, BlockPos node) {
        if (world != null && world.field_73011_w != null) {
            return this.getConnections(world.field_73011_w.getDimension(), node);
        }
        return null;
    }

    @Nullable
    public synchronized Set<Connection> getConnections(int world, BlockPos node) {
        ConcurrentHashMap<BlockPos, Set<Connection>> map = this.getMultimap(world);
        return map.get(node);
    }

    public void clearAllConnections(World world) {
        this.clearAllConnections(world.field_73011_w.getDimension());
    }

    public void clearAllConnections(int world) {
        this.getMultimap(world).clear();
        this.blockWireMap.func_76049_d(world);
        this.proxies.clear();
    }

    public void clearConnectionsOriginatingFrom(BlockPos node, World world) {
        this.resetCachedIndirectConnections(world, node);
        if (this.getMultimap(world.field_73011_w.getDimension()).containsKey(node)) {
            this.getMultimap(world.field_73011_w.getDimension()).get(node).clear();
        }
    }

    @Deprecated
    public void resetCachedIndirectConnections() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
            this.indirectConnectionsIgnoreOut.clear();
        } else {
            ImmersiveEngineering.proxy.clearConnectionModelCache();
        }
    }

    public void resetCachedIndirectConnections(World w, @Nullable BlockPos start) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            ImmersiveEngineering.proxy.clearConnectionModelCache();
            return;
        }
        int dimension = w.field_73011_w.getDimension();
        if (!this.directConnections.containsKey(dimension)) {
            return;
        }
        if (start == null) {
            for (BlockPos pos : this.directConnections.get(dimension).keySet()) {
                IImmersiveConnectable iic = ApiUtils.toIIC(pos, w);
                if (iic == null) continue;
                iic.onConnectivityUpdate(pos, dimension);
            }
            return;
        }
        Map connsForDim = this.directConnections.get(dimension);
        HashSet<BlockPos> open = new HashSet<BlockPos>();
        open.add(start);
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        while (!open.isEmpty()) {
            Set connsAtBlock;
            Iterator it = open.iterator();
            BlockPos next = (BlockPos)it.next();
            it.remove();
            closed.add(next);
            IImmersiveConnectable iic = ApiUtils.toIIC(next, w);
            if (iic != null) {
                iic.onConnectivityUpdate(next, dimension);
            }
            if ((connsAtBlock = (Set)connsForDim.get(next)) == null) continue;
            for (Connection c : connsAtBlock) {
                if (closed.contains(c.end)) continue;
                open.add(c.end);
            }
        }
    }

    public void removeConnectionAndDrop(Connection conn, World world, @Nullable BlockPos dropPos) {
        this.removeConnection(world, conn);
        if (dropPos != null) {
            double dx = (double)dropPos.func_177958_n() + 0.5;
            double dy = (double)dropPos.func_177956_o() + 0.5;
            double dz = (double)dropPos.func_177952_p() + 0.5;
            if (world.func_82736_K().func_82766_b("doTileDrops")) {
                world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, conn.cableType.getWireCoil(conn)));
            }
        }
    }

    public void clearAllConnectionsFor(BlockPos node, World world, boolean doDrops) {
        this.clearAllConnectionsFor(node, world, null, doDrops);
    }

    public void clearAllConnectionsFor(BlockPos node, World world, @Nullable IImmersiveConnectable iic, boolean doDrops) {
        if (iic == null) {
            iic = ApiUtils.toIIC(node, world);
        }
        if (iic != null) {
            iic.removeCable(null);
        }
        if (this.getMultimap(world.field_73011_w.getDimension()).containsKey(node)) {
            for (Connection con : this.getMultimap(world.field_73011_w.getDimension()).get(node)) {
                this.removeConnection(world, con, iic != null ? iic.getConnectionOffset(con) : Vec3d.field_186680_a, ApiUtils.getVecForIICAt(world, con.end, con));
                double dx = (double)node.func_177958_n() + 0.5 + (double)Math.signum(con.end.func_177958_n() - con.start.func_177958_n());
                double dy = (double)node.func_177956_o() + 0.5 + (double)Math.signum(con.end.func_177956_o() - con.start.func_177956_o());
                double dz = (double)node.func_177952_p() + 0.5 + (double)Math.signum(con.end.func_177952_p() - con.start.func_177952_p());
                if (!doDrops || !world.func_82736_K().func_82766_b("doTileDrops")) continue;
                world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil(con)));
            }
        }
        IESaveData.setDirty(world.field_73011_w.getDimension());
    }

    public void setProxy(DimensionBlockPos pos, IICProxy p) {
        if (p == null) {
            this.proxies.remove((Object)pos);
        } else {
            this.proxies.put(pos, p);
        }
    }

    public void addProxy(IICProxy p) {
        if (p == null) {
            return;
        }
        this.setProxy(new DimensionBlockPos(p.getPos(), p.getDimension()), p);
    }

    public boolean clearAllConnectionsFor(BlockPos node, World world, @Nonnull TargetingInfo target) {
        IImmersiveConnectable iic = ApiUtils.toIIC(node, world);
        WireType type = iic.getCableLimiter(target);
        if (type == null) {
            return false;
        }
        int dim = world.field_73011_w.getDimension();
        this.resetCachedIndirectConnections(world, node);
        boolean ret = false;
        for (Connection con : this.getMultimap(world.field_73011_w.getDimension()).get(node)) {
            if (con.cableType != type) continue;
            this.removeConnection(world, con);
            double dx = (double)node.func_177958_n() + 0.5 + (double)Math.signum(con.end.func_177958_n() - con.start.func_177958_n());
            double dy = (double)node.func_177956_o() + 0.5 + (double)Math.signum(con.end.func_177956_o() - con.start.func_177956_o());
            double dz = (double)node.func_177952_p() + 0.5 + (double)Math.signum(con.end.func_177952_p() - con.start.func_177952_p());
            if (world.func_82736_K().func_82766_b("doTileDrops")) {
                world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil(con)));
            }
            ret = true;
        }
        if (world.func_175667_e(node)) {
            world.func_175641_c(node, world.func_180495_p(node).func_177230_c(), -1, 0);
        }
        IESaveData.setDirty(dim);
        return ret;
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(BlockPos node, World world) {
        return this.getIndirectEnergyConnections(node, world, false);
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(BlockPos node, World world, boolean ignoreIsEnergyOutput) {
        int dimension = world.field_73011_w.getDimension();
        if (!ignoreIsEnergyOutput && this.indirectConnections.containsKey(dimension) && ((Map)this.indirectConnections.get(dimension)).containsKey(node)) {
            return (Set)((Map)this.indirectConnections.get(dimension)).get(node);
        }
        if (ignoreIsEnergyOutput && this.indirectConnectionsIgnoreOut.containsKey(dimension) && ((Map)this.indirectConnectionsIgnoreOut.get(dimension)).containsKey(node)) {
            return (Set)((Map)this.indirectConnectionsIgnoreOut.get(dimension)).get(node);
        }
        PriorityQueue<Pair> queue = new PriorityQueue<Pair>(Comparator.comparingDouble(Pair::getRight));
        Set<AbstractConnection> closedList = Collections.newSetFromMap(new ConcurrentHashMap());
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        HashMap<BlockPos, BlockPos> backtracker = new HashMap<BlockPos, BlockPos>();
        checked.add(node);
        Set<Connection> conL = this.getConnections(world, node);
        if (conL != null) {
            for (Connection con : conL) {
                IImmersiveConnectable end = ApiUtils.toIIC(con.end, world);
                if (end == null) continue;
                queue.add((Pair)new ImmutablePair((Object)end, (Object)Float.valueOf(con.getBaseLoss())));
                backtracker.put(con.end, node);
            }
        }
        int closedListMax = 1200;
        while (closedList.size() < 1200 && !queue.isEmpty()) {
            Set<Connection> conLN;
            Pair pair = queue.poll();
            IImmersiveConnectable next = (IImmersiveConnectable)pair.getLeft();
            float loss = ((Float)pair.getRight()).floatValue();
            BlockPos nextPos = ApiUtils.toBlockPos(next);
            if (checked.contains(nextPos) || !queue.stream().noneMatch(p -> ((IImmersiveConnectable)p.getLeft()).equals(nextPos))) continue;
            boolean isOutput = next.isEnergyOutput();
            if (ignoreIsEnergyOutput || isOutput) {
                BlockPos last = ApiUtils.toBlockPos(next);
                WireType minimumType = null;
                int distance = 0;
                ArrayList<Connection> connectionParts = new ArrayList<Connection>();
                block2: while (last != null) {
                    Set<Connection> conLB;
                    BlockPos prev = last;
                    if ((last = (BlockPos)backtracker.get(last)) == null || (conLB = this.getConnections(world, last)) == null) continue;
                    for (Connection conB : conLB) {
                        if (!conB.end.equals((Object)prev)) continue;
                        connectionParts.add(0, conB);
                        distance += conB.length;
                        if (minimumType != null && conB.cableType.getTransferRate() >= minimumType.getTransferRate()) continue block2;
                        minimumType = conB.cableType;
                        continue block2;
                    }
                }
                closedList.add(new AbstractConnection(ApiUtils.toBlockPos(node), ApiUtils.toBlockPos(next), minimumType, distance, isOutput, connectionParts.toArray(new Connection[connectionParts.size()])));
            }
            if ((conLN = this.getConnections(world, ApiUtils.toBlockPos(next))) != null) {
                for (Connection con : conLN) {
                    if (!next.allowEnergyToPass(con)) continue;
                    IImmersiveConnectable end = ApiUtils.toIIC(con.end, world);
                    Optional<Pair> existing = queue.stream().filter(p -> p.getLeft() == end).findAny();
                    float newLoss = con.getBaseLoss() + loss;
                    if (end == null || checked.contains(con.end) || !(existing.map(Pair::getRight).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue() > newLoss)) continue;
                    existing.ifPresent(p1 -> queue.removeIf(p2 -> p1.getLeft() == p2.getLeft()));
                    queue.add((Pair)new ImmutablePair((Object)end, (Object)Float.valueOf(newLoss)));
                    backtracker.put(con.end, ApiUtils.toBlockPos(next));
                }
            }
            checked.add(ApiUtils.toBlockPos(next));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            Map conns;
            if (ignoreIsEnergyOutput) {
                if (!this.indirectConnectionsIgnoreOut.containsKey(dimension)) {
                    this.indirectConnectionsIgnoreOut.put(dimension, new ConcurrentHashMap());
                }
                if (!(conns = (Map)this.indirectConnectionsIgnoreOut.get(dimension)).containsKey(node)) {
                    conns.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
                }
                ((Set)conns.get(node)).addAll(closedList);
            } else {
                if (!this.indirectConnections.containsKey(dimension)) {
                    this.indirectConnections.put(dimension, new ConcurrentHashMap());
                }
                if (!(conns = (Map)this.indirectConnections.get(dimension)).containsKey(node)) {
                    conns.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
                }
                ((Set)conns.get(node)).addAll(closedList);
            }
        }
        return closedList;
    }

    public static void handleEntityCollision(BlockPos p, Entity e) {
        BlockWireInfo info;
        Map mapForDim;
        if (!(e.field_70170_p.field_72995_K || !Config.IEConfig.enableWireDamage || !(e instanceof EntityLivingBase) || e.func_180431_b(IEDamageSources.wireShock) || e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75102_a || (mapForDim = (Map)ImmersiveNetHandler.INSTANCE.blockWireMap.func_76041_a(e.field_71093_bK)) == null || (info = (BlockWireInfo)mapForDim.get(p)) == null)) {
            ImmersiveNetHandler.handleMapForDamage(info.in, (EntityLivingBase)e, p);
            ImmersiveNetHandler.handleMapForDamage(info.near, (EntityLivingBase)e, p);
        }
    }

    private static void handleMapForDamage(Set<Triple<Connection, Vec3d, Vec3d>> in, EntityLivingBase e, BlockPos here) {
        double KNOCKBACK_PER_DAMAGE = 10.0;
        if (!in.isEmpty()) {
            AxisAlignedBB eAabb = e.func_174813_aQ();
            for (Triple<Connection, Vec3d, Vec3d> conn : in) {
                IEDamageSources.ElectricDamageSource dmg;
                RayTraceResult rayRes;
                if (!((Connection)conn.getLeft()).cableType.canCauseDamage()) continue;
                double extra = ((Connection)conn.getLeft()).cableType.getDamageRadius();
                AxisAlignedBB includingExtra = eAabb.func_186662_g(extra).func_72317_d((double)(-here.func_177958_n()), (double)(-here.func_177956_o()), (double)(-here.func_177952_p()));
                boolean endpointsInEntity = includingExtra.func_72318_a((Vec3d)conn.getMiddle()) || includingExtra.func_72318_a((Vec3d)conn.getRight());
                RayTraceResult rayTraceResult = rayRes = endpointsInEntity ? null : includingExtra.func_72327_a((Vec3d)conn.getMiddle(), (Vec3d)conn.getRight());
                if (!endpointsInEntity && (rayRes == null || rayRes.field_72313_a != RayTraceResult.Type.BLOCK)) continue;
                IImmersiveConnectable iic = ApiUtils.toIIC(((Connection)conn.getLeft()).start, e.field_70170_p);
                float damage = 0.0f;
                if (iic != null) {
                    damage = iic.getDamageAmount((Entity)e, (Connection)conn.getLeft());
                }
                if (damage == 0.0f && (iic = ApiUtils.toIIC(((Connection)conn.getLeft()).end, e.field_70170_p)) != null) {
                    damage = iic.getDamageAmount((Entity)e, (Connection)conn.getLeft());
                }
                if (damage == 0.0f || !(dmg = IEDamageSources.causeWireDamage(damage, ((Connection)conn.getLeft()).cableType.getElectricSource())).apply((Entity)e)) continue;
                damage = dmg.dmg;
                Vec3d v = e.func_70040_Z();
                ApiUtils.knockbackNoSource(e, (double)damage / 10.0, v.field_72450_a, v.field_72449_c);
                iic.processDamage((Entity)e, damage, (Connection)conn.getLeft());
            }
        }
    }

    public Connection getReverseConnection(int world, Connection ret) {
        return this.getConnections(world, ret.end).stream().filter(ret::hasSameConnectors).findAny().orElse(null);
    }

    public class BlockPlaceListener
    implements IWorldEventListener {
        public void func_184376_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState, int flags) {
            BlockWireInfo info;
            Map worldMap = (Map)ImmersiveNetHandler.this.blockWireMap.func_76041_a(worldIn.field_73011_w.getDimension());
            if (worldMap != null && !worldIn.field_72995_K && (flags & 1) != 0 && newState.func_177230_c().func_176209_a(newState, false) && (info = (BlockWireInfo)worldMap.get(pos)) != null) {
                Set<Triple<Connection, Vec3d, Vec3d>> conns = info.in;
                HashSet<ImmutablePair> toBreak = new HashSet<ImmutablePair>();
                for (Triple<Connection, Vec3d, Vec3d> triple : conns) {
                    Vec3d[] verts = ((Connection)triple.getLeft()).getSubVertices(worldIn);
                    if (Utils.isVecInBlock(verts[0], pos, ((Connection)triple.getLeft()).start) || Utils.isVecInBlock(verts[verts.length - 1], pos, ((Connection)triple.getLeft()).start)) continue;
                    BlockPos dropPos = pos;
                    if (!ApiUtils.preventsConnection(worldIn, pos, newState, (Vec3d)triple.getMiddle(), (Vec3d)triple.getRight())) continue;
                    for (EnumFacing f : EnumFacing.field_82609_l) {
                        if (!worldIn.func_175623_d(pos.func_177972_a(f))) continue;
                        dropPos = dropPos.func_177972_a(f);
                        break;
                    }
                    toBreak.add(new ImmutablePair(triple.getLeft(), (Object)dropPos));
                }
                for (Pair pair : toBreak) {
                    ImmersiveNetHandler.this.removeConnectionAndDrop((Connection)pair.getLeft(), worldIn, (BlockPos)pair.getRight());
                }
            }
        }

        public void func_174959_b(@Nonnull BlockPos pos) {
        }

        public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        }

        public void func_184375_a(EntityPlayer player, @Nonnull SoundEvent soundIn, @Nonnull SoundCategory category, double x, double y, double z, float volume, float pitch) {
        }

        public void func_184377_a(@Nonnull SoundEvent soundIn, @Nonnull BlockPos pos) {
        }

        public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        }

        public void func_72703_a(@Nonnull Entity entityIn) {
        }

        public void func_72709_b(@Nonnull Entity entityIn) {
        }

        public void func_180440_a(int soundID, @Nonnull BlockPos pos, int data) {
        }

        public void func_180439_a(EntityPlayer player, int type, @Nonnull BlockPos blockPosIn, int data) {
        }

        public void func_180441_b(int breakerId, @Nonnull BlockPos pos, int progress) {
        }
    }

    public class BlockWireInfo {
        @Nonnull
        public final Set<Triple<Connection, Vec3d, Vec3d>> in = Collections.newSetFromMap(new ConcurrentHashMap());
        @Nonnull
        public final Set<Triple<Connection, Vec3d, Vec3d>> near = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static class AbstractConnection
    extends Connection {
        public Connection[] subConnections;
        public boolean isEnergyOutput;

        public AbstractConnection(BlockPos start, BlockPos end, WireType cableType, int length, Connection ... subConnections) {
            this(start, end, cableType, length, true, subConnections);
        }

        public AbstractConnection(BlockPos start, BlockPos end, WireType cableType, int length, boolean output, Connection ... subConnections) {
            super(start, end, cableType, length);
            this.isEnergyOutput = output;
            this.subConnections = subConnections;
        }

        public float getPreciseLossRate(int energyInput, int connectorMaxInput) {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float mod = (float)(connectorMaxInput - energyInput) / (float)connectorMaxInput / 0.25f * 0.1f;
                f += c.getBaseLoss(mod);
            }
            return Math.min(f, 1.0f);
        }

        public float getAverageLossRate() {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                f += c.getBaseLoss();
            }
            return Math.min(f, 1.0f);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractConnection that = (AbstractConnection)o;
            return Arrays.equals(this.subConnections, that.subConnections);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.subConnections);
            return result;
        }
    }

    public static class Connection
    implements Comparable<Connection> {
        public BlockPos start;
        public BlockPos end;
        public WireType cableType;
        public int length;
        public Vec3d[] catenaryVertices;
        public static final int vertices = 17;
        public boolean vertical = false;
        public double catOffsetX;
        public double catOffsetY;
        public double catA;

        public Connection(BlockPos start, BlockPos end, WireType cableType, int length) {
            this.start = start;
            this.end = end;
            this.cableType = cableType;
            this.length = length;
        }

        public boolean hasSameConnectors(Connection con) {
            boolean n0 = this.start.equals((Object)con.start) && this.end.equals((Object)con.end);
            boolean n1 = this.start.equals((Object)con.end) && this.end.equals((Object)con.start);
            return n0 || n1;
        }

        public Vec3d[] getSubVertices(Vec3d start, Vec3d end) {
            if (this.catenaryVertices == null) {
                this.catenaryVertices = ApiUtils.getConnectionCatenary(this, start, end);
                this.vertical = start.field_72450_a == end.field_72450_a && start.field_72449_c == end.field_72449_c;
            }
            return this.catenaryVertices;
        }

        public Vec3d[] getSubVertices(World world) {
            return this.getSubVertices(ApiUtils.getVecForIICAt(world, this.start, this), ApiUtils.getVecForIICAt(world, this.end, this));
        }

        public Vec3d getVecAt(double pos, Vec3d vStart, Vec3d across, double lengthHor) {
            this.getSubVertices(vStart, vStart.func_178787_e(across));
            pos = MathHelper.func_151237_a((double)pos, (double)0.0, (double)1.0);
            if (this.vertical) {
                return vStart.func_178787_e(across.func_186678_a(pos / across.func_72433_c()));
            }
            return vStart.func_72441_c(pos * across.field_72450_a, this.catA * Math.cosh((pos * lengthHor - this.catOffsetX) / this.catA) + this.catOffsetY, pos * across.field_72449_c);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.start != null) {
                tag.func_74783_a("start", new int[]{this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p()});
            }
            if (this.end != null) {
                tag.func_74783_a("end", new int[]{this.end.func_177958_n(), this.end.func_177956_o(), this.end.func_177952_p()});
            }
            tag.func_74778_a("cableType", this.cableType.getUniqueName());
            tag.func_74768_a("length", this.length);
            return tag;
        }

        public static Connection readFromNBT(NBTTagCompound tag) {
            if (tag == null) {
                return null;
            }
            int[] iStart = tag.func_74759_k("start");
            BlockPos start = new BlockPos(iStart[0], iStart[1], iStart[2]);
            int[] iEnd = tag.func_74759_k("end");
            BlockPos end = new BlockPos(iEnd[0], iEnd[1], iEnd[2]);
            WireType type = ApiUtils.getWireTypeFromNBT(tag, "cableType");
            if (start != null && end != null && type != null) {
                return new Connection(start, end, type, tag.func_74762_e("length"));
            }
            return null;
        }

        @Override
        public int compareTo(@Nonnull Connection o) {
            if (this == o) {
                return 0;
            }
            int distComp = Integer.compare(this.length, o.length);
            int cableComp = -1 * Integer.compare(this.cableType.getTransferRate(), o.cableType.getTransferRate());
            if (cableComp != 0) {
                return cableComp;
            }
            if (distComp != 0) {
                return distComp;
            }
            if (this.start.func_177958_n() != o.start.func_177958_n()) {
                return this.start.func_177958_n() > o.start.func_177958_n() ? 1 : -1;
            }
            if (this.start.func_177956_o() != o.start.func_177956_o()) {
                return this.start.func_177956_o() > o.start.func_177956_o() ? 1 : -1;
            }
            if (this.start.func_177952_p() != o.start.func_177952_p()) {
                return this.start.func_177952_p() > o.start.func_177952_p() ? 1 : -1;
            }
            if (this.end.func_177958_n() != o.end.func_177958_n()) {
                return this.end.func_177958_n() > o.end.func_177958_n() ? 1 : -1;
            }
            if (this.end.func_177956_o() != o.end.func_177956_o()) {
                return this.end.func_177956_o() > o.end.func_177956_o() ? 1 : -1;
            }
            if (this.end.func_177952_p() != o.end.func_177952_p()) {
                return this.end.func_177952_p() > o.end.func_177952_p() ? 1 : -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Connection)) {
                return false;
            }
            return this.compareTo((Connection)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end, this.cableType);
        }

        public float getBaseLoss() {
            return this.getBaseLoss(0.0f);
        }

        public float getBaseLoss(float mod) {
            float lengthRelative = (float)this.length / (float)this.cableType.getMaxLength();
            return (float)((double)lengthRelative * this.cableType.getLossRatio() * (double)(1.0f + mod));
        }
    }
}

