/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.network.MessageObstructedConnection;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.util.vector.Vector3f;

public class ApiUtils {
    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        NonNullList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!OreDictionary.itemMatches((ItemStack)st, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return ApiUtils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false) && (!checkNBT || ((ItemStack)o).func_77952_i() == Short.MAX_VALUE || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false) || checkNBT && ((ItemStack)io).func_77952_i() != Short.MAX_VALUE && !Utils.compareItemNBT((ItemStack)io, stack)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientStack) {
                return ((IngredientStack)o).matchesItemStack(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false) || checkNBT && io.func_77952_i() != Short.MAX_VALUE && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
                    return fs != null && fs.containsFluid((FluidStack)o);
                }
                if (o instanceof String) {
                    return ApiUtils.compareToOreName(stack, (String)o);
                }
            }
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.func_190920_e(amount);
        return s2;
    }

    public static boolean stacksMatchIngredientList(List<IngredientStack> list, NonNullList<ItemStack> stacks) {
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack s : stacks) {
            if (s.func_190926_b()) continue;
            queryList.add(s.func_77946_l());
        }
        for (IngredientStack ingr : list) {
            if (ingr == null) continue;
            int amount = ingr.inputSize;
            Iterator it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (query.func_190926_b()) continue;
                if (ingr.matchesItemStackIgnoringSize(query)) {
                    if (query.func_190916_E() > amount) {
                        query.func_190918_g(amount);
                        amount = 0;
                    } else {
                        amount -= query.func_190916_E();
                        query.func_190920_e(0);
                    }
                }
                if (query.func_190916_E() <= 0) {
                    it.remove();
                }
                if (amount > 0) continue;
                break;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[list.size()]));
    }

    @Deprecated
    public static ComparableItemStack createComparableItemStack(ItemStack stack) {
        return ApiUtils.createComparableItemStack(stack, true);
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy) {
        return ApiUtils.createComparableItemStack(stack, copy, stack.func_77942_o() && !stack.func_77978_p().func_82582_d());
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy, boolean useNbt) {
        ComparableItemStack comp = new ComparableItemStack(stack, true, copy);
        comp.setUseNBT(useNbt);
        return comp;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static boolean isMetalComponent(ItemStack stack, String componentType) {
        return ApiUtils.getMetalComponentType(stack, componentType) != null;
    }

    public static String getMetalComponentType(ItemStack stack, String ... componentTypes) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] oreNames = OreDictionary.getOreNames();
        for (int id : ids) {
            String oreName = oreNames[id];
            for (String componentType : componentTypes) {
                if (!oreName.startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static String[] getMetalComponentTypeAndMetal(ItemStack stack, String ... componentTypes) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] oreNames = OreDictionary.getOreNames();
        for (int id : ids) {
            String oreName = oreNames[id];
            for (String componentType : componentTypes) {
                if (!oreName.startsWith(componentType)) continue;
                return new String[]{componentType, oreName.substring(componentType.length())};
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "ingot");
    }

    public static boolean isPlate(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "plate");
    }

    public static int getComponentIngotWorth(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String key = ApiUtils.getMetalComponentType(stack, keys);
        if (key != null && (relation = IEApi.prefixToIngotMap.get(key)) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return (int)val;
        }
        return 0;
    }

    public static ItemStack breakStackIntoIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return ApiUtils.copyStackWithAmount(IEApi.getPreferredOreStack("ingot" + type[1]), (int)val);
        }
        return ItemStack.field_190927_a;
    }

    public static Object[] breakStackIntoPreciseIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[IEApi.prefixToIngotMap.size()]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return new Object[]{IEApi.getPreferredOreStack("ingot" + type[1]), val};
        }
        return null;
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        if (!stack.func_190926_b() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
            return temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E();
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        if (!stack.func_190926_b() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.func_77946_l(), (boolean)true)).func_190926_b() || temp.func_190916_E() < stack.func_190916_E())) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side, boolean simulate) {
        if (inventory != null && !stack.func_190926_b() && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
        }
        return stack;
    }

    public static BlockPos toBlockPos(Object object) {
        if (object instanceof BlockPos) {
            return (BlockPos)object;
        }
        if (object instanceof TileEntity) {
            return ((TileEntity)object).func_174877_v();
        }
        if (object instanceof IICProxy) {
            return ((IICProxy)object).getPos();
        }
        return null;
    }

    public static IImmersiveConnectable toIIC(Object object, World world) {
        return ApiUtils.toIIC(object, world, true);
    }

    public static IImmersiveConnectable toIIC(Object object, World world, boolean allowProxies) {
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof BlockPos) {
            DimensionBlockPos pos;
            TileEntity te;
            if (world != null && world.func_175667_e((BlockPos)object) && (te = world.func_175625_s((BlockPos)object)) instanceof IImmersiveConnectable) {
                return (IImmersiveConnectable)te;
            }
            if (allowProxies && ImmersiveNetHandler.INSTANCE.proxies.containsKey((Object)(pos = new DimensionBlockPos((BlockPos)object, world)))) {
                return ImmersiveNetHandler.INSTANCE.proxies.get((Object)pos);
            }
        }
        return null;
    }

    public static Vec3d getVecForIICAt(World world, BlockPos pos, ImmersiveNetHandler.Connection conn) {
        Vec3d offset = Vec3d.field_186680_a;
        IImmersiveConnectable iicPos = ApiUtils.toIIC(pos, world, false);
        if (iicPos != null) {
            offset = iicPos.getConnectionOffset(conn);
        }
        if (pos.equals((Object)conn.end)) {
            offset = offset.func_72441_c((double)(conn.end.func_177958_n() - conn.start.func_177958_n()), (double)(conn.end.func_177956_o() - conn.start.func_177956_o()), (double)(conn.end.func_177952_p() - conn.start.func_177952_p()));
        }
        return offset;
    }

    public static Vec3d addVectors(Vec3d vec0, Vec3d vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x + 1.0) * Math.sqrt(x - 1.0));
    }

    public static Vec3d[] getConnectionCatenary(ImmersiveNetHandler.Connection connection, Vec3d start, Vec3d end) {
        boolean vertical;
        boolean bl = vertical = end.field_72450_a == start.field_72450_a && end.field_72449_c == start.field_72449_c;
        if (vertical) {
            Vec3d[] ret = new Vec3d[18];
            double height = end.field_72448_b - start.field_72448_b;
            for (int i = 0; i < 18; ++i) {
                ret[i] = new Vec3d(start.field_72450_a, start.field_72448_b + (double)i * height / 17.0, start.field_72449_c);
            }
            return ret;
        }
        return ApiUtils.getConnectionCatenary(start, end, connection.cableType.getSlack(), connection);
    }

    public static Vec3d[] getConnectionCatenary(Vec3d start, Vec3d end, double slack) {
        return ApiUtils.getConnectionCatenary(start, end, slack, null);
    }

    public static Vec3d[] getConnectionCatenary(Vec3d start, Vec3d end, double slack, @Nullable ImmersiveNetHandler.Connection c) {
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * slack;
        double l = 0.0;
        for (int limiter = 0; limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double offsetX = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double offsetY = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        if (c != null) {
            c.catOffsetX = offsetX;
            c.catOffsetY = offsetY;
            c.catA = a;
        }
        Vec3d[] vex = new Vec3d[18];
        vex[0] = new Vec3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        for (int i = 1; i < 17; ++i) {
            float posRelative = (float)i / 17.0f;
            double x = 0.0 + dx * (double)posRelative;
            double z = 0.0 + dz * (double)posRelative;
            double y = a * Math.cosh((dw * (double)posRelative - offsetX) / a) + offsetY;
            vex[i] = new Vec3d(start.field_72450_a + x, start.field_72448_b + y, start.field_72449_c + z);
        }
        vex[17] = new Vec3d(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        return vex;
    }

    public static double getDim(Vec3d vec, int dim) {
        return dim == 0 ? vec.field_72450_a : (dim == 1 ? vec.field_72448_b : vec.field_72449_c);
    }

    public static BlockPos offsetDim(BlockPos p, int dim, int amount) {
        return p.func_177982_a(dim == 0 ? amount : 0, dim == 1 ? amount : 0, dim == 2 ? amount : 0);
    }

    public static Vec3d offsetDim(Vec3d p, int dim, double amount) {
        return p.func_72441_c(dim == 0 ? amount : 0.0, dim == 1 ? amount : 0.0, dim == 2 ? amount : 0.0);
    }

    public static boolean raytraceAlongCatenary(ImmersiveNetHandler.Connection conn, World w, Predicate<Triple<BlockPos, Vec3d, Vec3d>> shouldStop, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close) {
        Vec3d vStart = ApiUtils.getVecForIICAt(w, conn.start, conn);
        Vec3d vEnd = ApiUtils.getVecForIICAt(w, conn.end, conn);
        return ApiUtils.raytraceAlongCatenaryRelative(conn, shouldStop, close, vStart, vEnd);
    }

    @Deprecated
    public static boolean raytraceAlongCatenary(ImmersiveNetHandler.Connection conn, Predicate<Triple<BlockPos, Vec3d, Vec3d>> shouldStop, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close, Vec3d vStart, Vec3d vEnd) {
        return ApiUtils.raytraceAlongCatenaryRelative(conn, shouldStop, close, vStart.func_178786_a((double)conn.start.func_177958_n(), (double)conn.start.func_177956_o(), (double)conn.start.func_177952_p()), vEnd.func_178786_a((double)conn.start.func_177958_n(), (double)conn.start.func_177956_o(), (double)conn.start.func_177952_p()));
    }

    public static boolean raytraceAlongCatenaryRelative(ImmersiveNetHandler.Connection conn, Predicate<Triple<BlockPos, Vec3d, Vec3d>> shouldStop, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close, Vec3d vStart, Vec3d vEnd) {
        boolean vertical;
        double factor;
        int i;
        conn.getSubVertices(vStart, vEnd);
        HashMap<BlockPos, Vec3d> halfScanned = new HashMap<BlockPos, Vec3d>();
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        HashSet<Triple<BlockPos, Vec3d, Vec3d>> near = new HashSet<Triple<BlockPos, Vec3d, Vec3d>>();
        Vec3d across = vEnd.func_178788_d(vStart);
        across = new Vec3d(across.field_72450_a, 0.0, across.field_72449_c);
        double lengthHor = across.func_72433_c();
        halfScanned.put(conn.start, vStart);
        halfScanned.put(conn.end, vEnd);
        for (int dim = 0; dim <= 2; dim += 2) {
            int start = (int)Math.ceil(Math.min(ApiUtils.getDim(vStart, dim), ApiUtils.getDim(vEnd, dim)));
            int n = (int)Math.ceil(Math.max(ApiUtils.getDim(vStart, dim), ApiUtils.getDim(vEnd, dim)));
            for (i = start; i < n; ++i) {
                factor = ((double)i - ApiUtils.getDim(vStart, dim)) / ApiUtils.getDim(across, dim);
                Vec3d pos = conn.getVecAt(factor, vStart, across, lengthHor);
                if (!ApiUtils.handleVec(pos, pos, 0, halfScanned, done, shouldStop, near, conn.start)) continue;
                return false;
            }
        }
        boolean bl = vertical = vStart.field_72450_a == vEnd.field_72450_a && vStart.field_72449_c == vEnd.field_72449_c;
        if (vertical) {
            int y = (int)Math.ceil(Math.min(vStart.field_72448_b, vEnd.field_72448_b));
            while ((double)y <= Math.floor(Math.max(vStart.field_72448_b, vEnd.field_72448_b))) {
                Vec3d vec3d = new Vec3d(vStart.field_72450_a, (double)y, vStart.field_72449_c);
                if (ApiUtils.handleVec(vec3d, vec3d, 0, halfScanned, done, shouldStop, near, conn.start)) {
                    return false;
                }
                ++y;
            }
        } else {
            double min = conn.catA + conn.catOffsetY + vStart.field_72448_b;
            for (i = 0; i < 2; ++i) {
                factor = i == 0 ? 1.0 : -1.0;
                double max = i == 0 ? vEnd.field_72448_b : vStart.field_72448_b;
                int y = (int)Math.ceil(min);
                while ((double)y <= Math.floor(max)) {
                    double yReal = (double)y - vStart.field_72448_b;
                    double posRel = (factor * ApiUtils.acosh((yReal - conn.catOffsetY) / conn.catA) * conn.catA + conn.catOffsetX) / lengthHor;
                    Vec3d pos = new Vec3d(vStart.field_72450_a + across.field_72450_a * posRel, (double)y, vStart.field_72449_c + across.field_72449_c * posRel);
                    if (posRel >= 0.0 && posRel <= 1.0 && ApiUtils.handleVec(pos, pos, 0, halfScanned, done, shouldStop, near, conn.start)) {
                        return false;
                    }
                    ++y;
                }
            }
        }
        for (Triple triple : near) {
            close.accept((Triple<BlockPos, Vec3d, Vec3d>)triple);
        }
        for (Map.Entry entry : halfScanned.entrySet()) {
            if (!shouldStop.test((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple(entry.getKey(), entry.getValue(), entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    private static boolean handleVec(Vec3d pos, Vec3d origPos, int start, HashMap<BlockPos, Vec3d> halfScanned, HashSet<BlockPos> done, Predicate<Triple<BlockPos, Vec3d, Vec3d>> shouldStop, HashSet<Triple<BlockPos, Vec3d, Vec3d>> near, BlockPos offset) {
        double DELTA_HIT = 1.0E-5;
        double EPSILON = 1.0E-5;
        boolean calledOther = false;
        for (int i = start; i < 3; ++i) {
            double coord = ApiUtils.getDim(pos, i);
            double diff = coord - Math.floor(coord);
            if (diff < 1.0E-5) {
                if (ApiUtils.handleVec(ApiUtils.offsetDim(pos, i, -(diff + 1.0E-5)), origPos, i + 1, halfScanned, done, shouldStop, near, offset)) {
                    return true;
                }
                calledOther = true;
            }
            if (!((diff = Math.ceil(coord) - coord) < 1.0E-5)) continue;
            if (ApiUtils.handleVec(ApiUtils.offsetDim(pos, i, diff + 1.0E-5), origPos, i + 1, halfScanned, done, shouldStop, near, offset)) {
                return true;
            }
            calledOther = true;
        }
        if (!calledOther) {
            BlockPos blockPos = new BlockPos(pos);
            return ApiUtils.handlePos(origPos.func_178786_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), blockPos.func_177971_a((Vec3i)offset), halfScanned, done, shouldStop, near);
        }
        return false;
    }

    private static boolean handlePos(Vec3d pos, BlockPos posB, HashMap<BlockPos, Vec3d> halfScanned, HashSet<BlockPos> done, Predicate<Triple<BlockPos, Vec3d, Vec3d>> shouldStop, HashSet<Triple<BlockPos, Vec3d, Vec3d>> near) {
        double DELTA_NEAR = 0.3;
        if (!done.contains(posB)) {
            if (halfScanned.containsKey(posB) && !pos.equals((Object)halfScanned.get(posB))) {
                ImmutableTriple added = new ImmutableTriple((Object)posB, (Object)halfScanned.get(posB), (Object)pos);
                boolean stop = shouldStop.test((Triple<BlockPos, Vec3d, Vec3d>)added);
                done.add(posB);
                halfScanned.remove(posB);
                near.removeIf(t -> ((BlockPos)t.getLeft()).equals((Object)posB));
                if (stop) {
                    return true;
                }
                for (int i = 0; i < 3; ++i) {
                    double coord = ApiUtils.getDim(pos, i);
                    double diff = coord - Math.floor(coord);
                    if (diff < 0.3) {
                        near.add((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple((Object)ApiUtils.offsetDim(posB, i, -1), added.getMiddle(), added.getRight()));
                    }
                    if (!((diff = Math.ceil(coord) - coord) < 0.3)) continue;
                    near.add((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple((Object)ApiUtils.offsetDim(posB, i, 1), added.getMiddle(), added.getRight()));
                }
            } else {
                halfScanned.put(posB, pos);
            }
        }
        return false;
    }

    public static WireType getWireTypeFromNBT(NBTTagCompound tag, String key) {
        if (tag.func_74781_a(key) instanceof NBTTagInt) {
            int i = tag.func_74762_e(key);
            return i == 1 ? WireType.ELECTRUM : (i == 2 ? WireType.STEEL : (i == 3 ? WireType.STRUCTURE_ROPE : (i == 4 ? WireType.STRUCTURE_STEEL : WireType.COPPER)));
        }
        return WireType.getValue(tag.func_74779_i(key));
    }

    public static EnumActionResult doCoilUse(IWireCoil coil, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            ItemStack stack = player.func_184586_b(hand);
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            WireType wire = coil.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, target);
            BlockPos offset = pos.func_177973_b((Vec3i)masterPos);
            tileEntity = world.func_175625_s(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return EnumActionResult.PASS;
            }
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(wire, target, (Vec3i)offset) || !coil.canConnectCable(stack, tileEntity)) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.wrongCable", new Object[0]), true);
                }
                return EnumActionResult.FAIL;
            }
            if (!world.field_72995_K) {
                if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                    ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.getDimension(), masterPos.func_177958_n(), masterPos.func_177956_o(), masterPos.func_177952_p(), offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()});
                    NBTTagCompound targetNbt = new NBTTagCompound();
                    target.writeToNBT(targetNbt);
                    ItemNBTHelper.setTagCompound(stack, "targettingInfo", targetNbt);
                } else {
                    int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
                    BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                    Vec3i offsetLink = BlockPos.field_177959_e;
                    if (array.length == 7) {
                        offsetLink = new Vec3i(array[4], array[5], array[6]);
                    }
                    TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
                    int distanceSq = (int)Math.ceil(linkPos.func_177951_i((Vec3i)masterPos));
                    int maxLengthSq = coil.getMaxLength(stack);
                    maxLengthSq *= maxLengthSq;
                    if (array[0] != world.field_73011_w.getDimension()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.wrongDimension", new Object[0]), true);
                    } else if (linkPos.equals((Object)masterPos)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.sameConnection", new Object[0]), true);
                    } else if (distanceSq > maxLengthSq) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.tooFar", new Object[0]), true);
                    } else {
                        TargetingInfo targetLink = TargetingInfo.readFromNBT(ItemNBTHelper.getTagCompound(stack, "targettingInfo"));
                        if (!(tileEntityLinkingPos instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(wire, targetLink, offsetLink) && ((IImmersiveConnectable)tileEntityLinkingPos).getConnectionMaster(wire, targetLink).equals((Object)linkPos) && coil.canConnectCable(stack, tileEntityLinkingPos))) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.invalidPoint", new Object[0]), true);
                        } else {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            boolean connectionExists = false;
                            Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC(nodeHere));
                            if (outputs != null) {
                                for (ImmersiveNetHandler.Connection con : outputs) {
                                    if (!con.end.equals((Object)Utils.toCC(nodeLink))) continue;
                                    connectionExists = true;
                                }
                            }
                            if (connectionExists) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.connectionExists", new Object[0]), true);
                            } else {
                                HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                                ignore.addAll(nodeHere.getIgnored(nodeLink));
                                ignore.addAll(nodeLink.getIgnored(nodeHere));
                                ImmersiveNetHandler.Connection tmpConn = new ImmersiveNetHandler.Connection(Utils.toCC(nodeHere), Utils.toCC(nodeLink), wire, (int)Math.sqrt(distanceSq));
                                Vec3d start = nodeHere.getConnectionOffset(tmpConn, target, (Vec3i)pos.func_177973_b((Vec3i)masterPos));
                                Vec3d end = nodeLink.getConnectionOffset(tmpConn, targetLink, offsetLink).func_72441_c((double)(linkPos.func_177958_n() - masterPos.func_177958_n()), (double)(linkPos.func_177956_o() - masterPos.func_177956_o()), (double)(linkPos.func_177952_p() - masterPos.func_177952_p()));
                                BlockPos.MutableBlockPos failedReason = new BlockPos.MutableBlockPos();
                                boolean canSee = ApiUtils.raytraceAlongCatenaryRelative(tmpConn, p -> {
                                    if (ignore.contains(p.getLeft())) {
                                        return false;
                                    }
                                    IBlockState state = world.func_180495_p((BlockPos)p.getLeft());
                                    if (ApiUtils.preventsConnection(world, (BlockPos)p.getLeft(), state, (Vec3d)p.getMiddle(), (Vec3d)p.getRight())) {
                                        failedReason.func_189533_g((Vec3i)p.getLeft());
                                        return true;
                                    }
                                    return false;
                                }, p -> {}, start, end);
                                if (canSee) {
                                    ImmersiveNetHandler.Connection conn = ImmersiveNetHandler.INSTANCE.addAndGetConnection(world, Utils.toCC(nodeHere), Utils.toCC(nodeLink), (int)Math.sqrt(distanceSq), wire);
                                    nodeHere.connectCable(wire, target, nodeLink, (Vec3i)offset);
                                    nodeLink.connectCable(wire, targetLink, nodeHere, offsetLink);
                                    ImmersiveNetHandler.INSTANCE.addBlockData(world, conn);
                                    IESaveData.setDirty(world.field_73011_w.getDimension());
                                    Utils.unlockIEAdvancement(player, "main/connect_wire");
                                    if (!player.field_71075_bZ.field_75098_d) {
                                        coil.consumeWire(stack, (int)Math.sqrt(distanceSq));
                                    }
                                    ((TileEntity)nodeHere).func_70296_d();
                                    world.func_175641_c(masterPos, ((TileEntity)nodeHere).func_145838_q(), -1, 0);
                                    IBlockState state = world.func_180495_p(masterPos);
                                    world.func_184138_a(masterPos, state, state, 3);
                                    ((TileEntity)nodeLink).func_70296_d();
                                    world.func_175641_c(linkPos, ((TileEntity)nodeLink).func_145838_q(), -1, 0);
                                    state = world.func_180495_p(linkPos);
                                    world.func_184138_a(linkPos, state, state, 3);
                                } else {
                                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.cantSee", new Object[0]), true);
                                    ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageObstructedConnection(tmpConn, (BlockPos)failedReason, player.field_70170_p), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
                                }
                            }
                        }
                    }
                    ItemNBTHelper.remove(stack, "linkingPos");
                    ItemNBTHelper.remove(stack, "targettingInfo");
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static Object convertToValidRecipeInput(Object input) {
        if (input instanceof ItemStack) {
            return input;
        }
        if (input instanceof Item) {
            return new ItemStack((Item)input);
        }
        if (input instanceof Block) {
            return new ItemStack((Block)input);
        }
        if (input instanceof List) {
            return input;
        }
        if (input instanceof String) {
            if (!ApiUtils.isExistingOreName((String)input)) {
                return null;
            }
            NonNullList l = OreDictionary.getOres((String)((String)input));
            if (!l.isEmpty()) {
                return l;
            }
            return null;
        }
        throw new RuntimeException("Recipe Inputs must always be ItemStack, Item, Block or String (OreDictionary name), " + input + " is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IngredientStack createIngredientStack(Object input, boolean preferWildcard) {
        if (input instanceof IngredientStack) {
            return (IngredientStack)input;
        }
        if (input instanceof ItemStack) {
            return new IngredientStack((ItemStack)input);
        }
        if (input instanceof Item) {
            if (!preferWildcard) return new IngredientStack(new ItemStack((Item)input));
            return new IngredientStack(new ItemStack((Item)input, 1, Short.MAX_VALUE));
        }
        if (input instanceof Block) {
            if (!preferWildcard) return new IngredientStack(new ItemStack((Block)input));
            return new IngredientStack(new ItemStack((Block)input, 1, Short.MAX_VALUE));
        }
        if (input instanceof Ingredient) {
            return new IngredientStack(Arrays.asList(((Ingredient)input).func_193365_a()));
        }
        if (input instanceof List) {
            if (((List)input).isEmpty()) return new IngredientStack(ItemStack.field_190927_a);
            if (((List)input).get(0) instanceof ItemStack) {
                return new IngredientStack((List)input);
            }
            if (!(((List)input).get(0) instanceof String)) throw new RuntimeException("Recipe Ingredients must always be ItemStack, Item, Block, List<ItemStack>, String (OreDictionary name) or FluidStack; " + input + " is invalid");
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            for (String s : (List)input) {
                itemList.addAll((Collection<ItemStack>)OreDictionary.getOres((String)s));
            }
            return new IngredientStack(itemList);
        }
        if (input instanceof ItemStack[]) {
            return new IngredientStack(Arrays.asList((ItemStack[])input));
        }
        if (input instanceof String[]) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            for (String s : (String[])input) {
                itemList.addAll((Collection<ItemStack>)OreDictionary.getOres((String)s));
            }
            return new IngredientStack(itemList);
        }
        if (input instanceof String) {
            return new IngredientStack((String)input);
        }
        if (!(input instanceof FluidStack)) throw new RuntimeException("Recipe Ingredients must always be ItemStack, Item, Block, List<ItemStack>, String (OreDictionary name) or FluidStack; " + input + " is invalid");
        return new IngredientStack((FluidStack)input);
    }

    public static IngredientStack createIngredientStack(Object input) {
        return ApiUtils.createIngredientStack(input, false);
    }

    public static ItemStack getItemStackFromObject(Object o) {
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        if (o instanceof List) {
            return (ItemStack)((List)o).get(0);
        }
        if (o instanceof String) {
            if (!ApiUtils.isExistingOreName((String)o)) {
                return ItemStack.field_190927_a;
            }
            NonNullList l = OreDictionary.getOres((String)((String)o));
            if (!l.isEmpty()) {
                return (ItemStack)l.get(0);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasPlayerIngredient(EntityPlayer player, IngredientStack ingredient) {
        ItemStack itemstack;
        int amount = ingredient.inputSize;
        for (EnumHand hand : EnumHand.values()) {
            itemstack = player.func_184586_b(hand);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack) || (amount -= itemstack.func_190916_E()) > 0) continue;
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack) || (amount -= itemstack.func_190916_E()) > 0) continue;
            return true;
        }
        return amount <= 0;
    }

    public static void consumePlayerIngredient(EntityPlayer player, IngredientStack ingredient) {
        ItemStack itemstack;
        int amount = ingredient.inputSize;
        for (EnumHand hand : EnumHand.values()) {
            itemstack = player.func_184586_b(hand);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.func_190916_E());
            amount -= taken;
            itemstack.func_190918_g(taken);
            if (itemstack.func_190916_E() <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (amount > 0) continue;
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            if (!ingredient.matchesItemStackIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.func_190916_E());
            amount -= taken;
            itemstack.func_190918_g(taken);
            if (itemstack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (amount > 0) continue;
            return;
        }
    }

    public static Map<String, Integer> sortMap(Map<String, Integer> map, boolean inverse) {
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(new ValueComparator(map, inverse));
        sortedMap.putAll(map);
        return sortedMap;
    }

    public static <T extends TileEntity> void checkForNeedlessTicking(T te) {
        if (!te.func_145831_w().field_72995_K && ((IEBlockInterfaces.IGeneralMultiblock)te).isLogicDummy()) {
            EventHandler.REMOVE_FROM_TICKING.add(te);
        }
    }

    public static boolean preventsConnection(World worldIn, BlockPos pos, IBlockState state, Vec3d a, Vec3d b) {
        if (state.func_177230_c().func_176209_a(state, false)) {
            ArrayList aabbs = new ArrayList(1);
            state.func_185908_a(worldIn, pos, Block.field_185505_j.func_186670_a(pos), aabbs, null, false);
            for (AxisAlignedBB aabb : aabbs) {
                if (!(aabb = aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())).func_186662_g(1.0E-5)).func_72318_a(a) && !aabb.func_72318_a(b)) continue;
                return true;
            }
            RayTraceResult rayResult = state.func_185910_a(worldIn, pos, a.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), b.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            return rayResult != null && rayResult.field_72313_a == RayTraceResult.Type.BLOCK;
        }
        return false;
    }

    public static void knockbackNoSource(EntityLivingBase entity, double strength, double xRatio, double zRatio) {
        entity.field_70160_al = true;
        float factor = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        entity.field_70159_w /= 2.0;
        entity.field_70179_y /= 2.0;
        entity.field_70159_w -= xRatio / (double)factor * strength;
        entity.field_70179_y -= zRatio / (double)factor * strength;
        if (entity.field_70122_E) {
            entity.field_70181_x /= 2.0;
            entity.field_70181_x += strength;
            if (entity.field_70181_x > 0.4) {
                entity.field_70181_x = 0.4;
            }
        }
    }

    public static ImmersiveNetHandler.Connection getTargetConnection(World world, EntityPlayer player, ImmersiveNetHandler.Connection ignored, double maxDistance) {
        Vec3d across;
        Vec3d look = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d end = start.func_178787_e(look.func_186678_a(maxDistance));
        Map inDim = (Map)ImmersiveNetHandler.INSTANCE.blockWireMap.func_76041_a(player.field_71093_bK);
        AtomicReference ret = new AtomicReference();
        AtomicDouble minDistSq = new AtomicDouble(Double.POSITIVE_INFINITY);
        Utils.rayTrace(start, end, world, pos -> {
            if (inDim != null && inDim.containsKey(pos)) {
                ImmersiveNetHandler.BlockWireInfo info = (ImmersiveNetHandler.BlockWireInfo)inDim.get(pos);
                for (int i = 0; i < 2; ++i) {
                    Set<Triple<ImmersiveNetHandler.Connection, Vec3d, Vec3d>> conns = i == 0 ? info.in : info.near;
                    for (Triple<ImmersiveNetHandler.Connection, Vec3d, Vec3d> conn : conns) {
                        ImmersiveNetHandler.Connection c = (ImmersiveNetHandler.Connection)conn.getLeft();
                        if (ignored != null && c.hasSameConnectors(ignored)) continue;
                        Vec3d startRelative = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                        Vec3d across = ((Vec3d)conn.getRight()).func_178788_d((Vec3d)conn.getMiddle());
                        double t = Utils.getCoeffForMinDistance(startRelative, (Vec3d)conn.getMiddle(), across);
                        t = MathHelper.func_151237_a((double)0.0, (double)t, (double)1.0);
                        Vec3d closest = ((Vec3d)conn.getMiddle()).func_72441_c(t * across.field_72450_a, t * across.field_72448_b, t * across.field_72449_c);
                        double distSq = closest.func_72436_e(startRelative);
                        if (!(distSq < minDistSq.get())) continue;
                        ret.set(c);
                        minDistSq.set(distSq);
                    }
                }
            }
        });
        ImmersiveNetHandler.Connection retConn = (ImmersiveNetHandler.Connection)ret.get();
        if (retConn != null && (across = new Vec3d((Vec3i)retConn.end).func_178788_d(new Vec3d((Vec3i)retConn.start))).func_72430_b(player.func_70040_Z()) < 0.0) {
            retConn = ImmersiveNetHandler.INSTANCE.getReverseConnection(world.field_73011_w.getDimension(), retConn);
        }
        return retConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFutureServerTask(World world, Runnable task) {
        if (world.func_73046_m() != null) {
            Queue queue = world.func_73046_m().field_175589_i;
            synchronized (queue) {
                world.func_73046_m().field_175589_i.add(ListenableFutureTask.create((Runnable)task, null));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getRegisterSprite(TextureMap map, String path) {
        TextureAtlasSprite sprite = map.getTextureExtry(path);
        if (sprite == null) {
            map.func_174942_a(new ResourceLocation(path));
            sprite = map.getTextureExtry(path);
        }
        return sprite;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getRegisterSprite(TextureMap map, ResourceLocation path) {
        TextureAtlasSprite sprite = map.getTextureExtry(path.toString());
        if (sprite == null) {
            map.func_174942_a(path);
            sprite = map.getTextureExtry(path.toString());
        }
        return sprite;
    }

    @SideOnly(value=Side.CLIENT)
    public static Function<BakedQuad, BakedQuad> transformQuad(final Matrix4 mat, final VertexFormat f, final Function<Integer, Integer> colorMultiplier) {
        int posPos = -1;
        int normPos = -1;
        int colorPos = -1;
        for (int i = 0; i < f.func_177343_g().size(); ++i) {
            if (f.func_177348_c(i).func_177375_c() == VertexFormatElement.EnumUsage.POSITION) {
                posPos = i;
                continue;
            }
            if (f.func_177348_c(i).func_177375_c() == VertexFormatElement.EnumUsage.NORMAL) {
                normPos = i;
                continue;
            }
            if (f.func_177348_c(i).func_177375_c() != VertexFormatElement.EnumUsage.COLOR) continue;
            colorPos = i;
        }
        if (posPos == -1) {
            return null;
        }
        final int posPosFinal = posPos;
        final int normPosFinal = normPos;
        final int colorPosFinal = colorPos;
        final AtomicReference ref = new AtomicReference();
        final Matrix4 inverse = mat.copy();
        inverse.invert();
        inverse.transpose();
        IVertexConsumer transformer = new IVertexConsumer(){
            int tintIndex = -1;

            @Nonnull
            public VertexFormat getVertexFormat() {
                return f;
            }

            public void setQuadTint(int tint) {
                ((UnpackedBakedQuad.Builder)ref.get()).setQuadTint(tint);
                this.tintIndex = tint;
            }

            public void setQuadOrientation(@Nonnull EnumFacing orientation) {
                ((UnpackedBakedQuad.Builder)ref.get()).setQuadOrientation(orientation);
            }

            public void setApplyDiffuseLighting(boolean diffuse) {
                ((UnpackedBakedQuad.Builder)ref.get()).setApplyDiffuseLighting(diffuse);
            }

            public void setTexture(@Nonnull TextureAtlasSprite texture) {
                ((UnpackedBakedQuad.Builder)ref.get()).setTexture(texture);
            }

            public void put(int element, float ... data) {
                int multiplier;
                if (element == posPosFinal) {
                    Vector3f newPos = mat.apply(new Vector3f(data[0], data[1], data[2]));
                    data = new float[]{newPos.x, newPos.y, newPos.z};
                } else if (element == normPosFinal) {
                    Vector3f newNormal = inverse.apply(new Vector3f(data[0], data[1], data[2]));
                    data = new float[]{newNormal.x, newNormal.y, newNormal.z};
                } else if (element == colorPosFinal && this.tintIndex != -1 && colorMultiplier != null && (multiplier = ((Integer)colorMultiplier.apply(this.tintIndex)).intValue()) != 0) {
                    float r = (float)(multiplier >> 16 & 0xFF) / 255.0f;
                    float g = (float)(multiplier >> 8 & 0xFF) / 255.0f;
                    float b = (float)(multiplier & 0xFF) / 255.0f;
                    float[] oldData = data;
                    data = new float[]{oldData[0] * r, oldData[1] * g, oldData[2] * b, oldData[3]};
                }
                ((UnpackedBakedQuad.Builder)ref.get()).put(element, data);
            }
        };
        return q -> {
            ref.set(new UnpackedBakedQuad.Builder(f));
            q.pipe(transformer);
            return ((UnpackedBakedQuad.Builder)ref.get()).build();
        };
    }

    public static class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;
        boolean inverse;

        public ValueComparator(Map<String, Integer> base, boolean inverse) {
            this.base = base;
            this.inverse = inverse;
        }

        @Override
        public int compare(String s0, String s1) {
            if (this.inverse) {
                if (this.base.get(s0) <= this.base.get(s1)) {
                    return -1;
                }
                return 1;
            }
            if (this.base.get(s0) >= this.base.get(s1)) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ValueComparator)) {
                return false;
            }
            ValueComparator other = (ValueComparator)obj;
            return other.base == this.base && other.inverse == this.inverse;
        }
    }
}

