/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageObstructedConnection
implements IMessage {
    private Vec3d start;
    private Vec3d end;
    private BlockPos startB;
    private BlockPos endB;
    private BlockPos blocking;
    private WireType wireType;

    public MessageObstructedConnection(ImmersiveNetHandler.Connection conn, BlockPos blocking, World w) {
        this.blocking = blocking;
        Vec3d[] vertices = conn.getSubVertices(w);
        this.start = vertices[0];
        this.end = vertices[vertices.length - 1];
        this.startB = conn.start;
        this.endB = conn.end;
        this.wireType = conn.cableType;
    }

    public MessageObstructedConnection() {
    }

    public void fromBytes(ByteBuf buf) {
        this.start = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.end = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.startB = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.endB = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.blocking = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.wireType = WireType.getValue(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.start.field_72450_a).writeDouble(this.start.field_72448_b).writeDouble(this.start.field_72449_c);
        buf.writeDouble(this.end.field_72450_a).writeDouble(this.end.field_72448_b).writeDouble(this.end.field_72449_c);
        buf.writeInt(this.startB.func_177958_n()).writeInt(this.startB.func_177956_o()).writeInt(this.startB.func_177952_p());
        buf.writeInt(this.endB.func_177958_n()).writeInt(this.endB.func_177956_o()).writeInt(this.endB.func_177952_p());
        buf.writeInt(this.blocking.func_177958_n()).writeInt(this.blocking.func_177956_o()).writeInt(this.blocking.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.wireType.getUniqueName());
    }

    public static class Handler
    implements IMessageHandler<MessageObstructedConnection, IMessage> {
        public IMessage onMessage(MessageObstructedConnection message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                ImmersiveNetHandler.Connection conn = new ImmersiveNetHandler.Connection(message.startB, message.endB, message.wireType, (int)Math.sqrt(message.startB.func_177951_i((Vec3i)message.endB)));
                conn.getSubVertices(message.start, message.end);
                ImmersiveEngineering.proxy.addFailedConnection(conn, message.blocking, null);
            });
            return null;
        }
    }
}

