/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageBirthdayParty;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRevolvershot
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private boolean inGround;
    public EntityLivingBase shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private float movementDecay = 0.0f;
    private float gravity = 0.0f;
    private int tickLimit = 40;
    String bulletType;
    public boolean bulletElectro = false;
    public ItemStack bulletPotion = ItemStack.field_190927_a;
    private static final DataParameter<String> dataMarker_shooter = EntityDataManager.func_187226_a(EntityRevolvershot.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityRevolvershot(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
    }

    public EntityRevolvershot(World world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        this.bulletType = BulletHandler.findRegistryName(type);
    }

    public EntityRevolvershot(World world, EntityLivingBase living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        this(world, living, ax, ay, az, BulletHandler.findRegistryName(type), stack);
    }

    public EntityRevolvershot(World world, EntityLivingBase living, double ax, double ay, double az, String type, ItemStack stack) {
        super(world);
        this.shootingEntity = living;
        this.setShooterSynced();
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(living.field_70165_t + ax, living.field_70163_u + (double)living.func_70047_e() + ay, living.field_70161_v + az, living.field_70177_z, living.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.bulletType = type;
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setMovementDecay(float f) {
        this.movementDecay = f;
    }

    public void setGravity(float f) {
        this.gravity = f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataMarker_shooter, (Object)"");
    }

    public void setShooterSynced() {
        this.field_70180_af.func_187227_b(dataMarker_shooter, (Object)this.shootingEntity.func_70005_c_());
    }

    public EntityLivingBase getShooterSynced() {
        return this.field_70170_p.func_72924_a((String)this.field_70180_af.func_187225_a(dataMarker_shooter));
    }

    public Entity getShooter() {
        return this.shootingEntity;
    }

    public void func_70071_h_() {
        if (this.getShooter() == null && this.field_70170_p.field_72995_K) {
            this.shootingEntity = this.getShooterSynced();
        }
        if (!this.field_70170_p.field_72995_K && this.shootingEntity != null && this.shootingEntity.field_70128_L) {
            this.func_70106_y();
        } else {
            AxisAlignedBB axisalignedbb;
            BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.inGround = true;
            }
            super.func_70071_h_();
            if (this.inGround) {
                int j = block.func_176201_c(iblockstate);
                if (block == this.inTile && j == this.inData) {
                    ++this.ticksInGround;
                    if (this.ticksInGround >= 1200) {
                        this.func_70106_y();
                    }
                } else {
                    this.inGround = false;
                    this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.ticksInGround = 0;
                    this.ticksInAir = 0;
                }
            } else {
                ++this.ticksInAir;
            }
            if (this.ticksInAir >= this.tickLimit) {
                this.onExpire();
                this.func_70106_y();
                return;
            }
            Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec31 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.shootingEntity)) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb2 = entity1.func_174813_aQ().func_186662_g((double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb2.func_72327_a(vec3, vec31);
                if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null) {
                this.onImpact(movingobjectposition);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float decay = this.movementDecay;
            if (this.func_70090_H()) {
                float f3 = 0.25f;
                for (int j = 0; j < 4; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                decay = (float)((double)decay * 0.6);
            }
            if (decay != 0.0f) {
                this.field_70159_w *= (double)decay;
                this.field_70181_x *= (double)decay;
                this.field_70179_y *= (double)decay;
            }
            if (this.gravity != 0.0f) {
                this.field_70181_x -= (double)this.gravity;
            }
            if (this.field_70173_aa % 4 == 0) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected void onImpact(RayTraceResult mop) {
        boolean headshot = false;
        if (mop.field_72308_g instanceof EntityLivingBase) {
            headshot = Utils.isVecInEntityHead((EntityLivingBase)mop.field_72308_g, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        }
        if (this.bulletType != null) {
            BulletHandler.IBullet bullet = BulletHandler.getBullet(this.bulletType);
            if (bullet != null) {
                bullet.onHitTarget(this.field_70170_p, mop, this.shootingEntity, this, headshot);
            }
            if (headshot && mop.field_72308_g instanceof EntityAgeable && ((EntityAgeable)mop.field_72308_g).func_70631_g_() && ((EntityLivingBase)mop.field_72308_g).func_110143_aJ() <= 0.0f) {
                if (this.shootingEntity instanceof EntityPlayer) {
                    Utils.unlockIEAdvancement((EntityPlayer)this.shootingEntity, "main/secret_birthdayparty");
                }
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, IESounds.birthdayParty, SoundCategory.PLAYERS, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                ImmersiveEngineering.packetHandler.sendToDimension((IMessage)new MessageBirthdayParty((EntityLivingBase)mop.field_72308_g), this.field_70170_p.field_73011_w.getDimension());
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.secondaryImpact(mop);
        }
        this.func_70106_y();
    }

    public void secondaryImpact(RayTraceResult mop) {
        if (this.bulletElectro && mop.field_72308_g instanceof EntityLivingBase) {
            BulletHandler.IBullet bullet = BulletHandler.getBullet(this.bulletType);
            float percentualDrain = 0.15f / (float)(bullet == null ? 1 : bullet.getProjectileCount(this.shootingEntity instanceof EntityPlayer ? (EntityPlayer)this.shootingEntity : null));
            ((EntityLivingBase)mop.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 15, 4));
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                int actualDrain;
                ItemStack stack = ((EntityLivingBase)mop.field_72308_g).func_184582_a(slot);
                if (!EnergyHelper.isFluxItem(stack) || EnergyHelper.getEnergyStored(stack) <= 0) continue;
                int drain = (int)Math.max((float)EnergyHelper.getEnergyStored(stack), (float)EnergyHelper.getMaxEnergyStored(stack) * percentualDrain);
                for (int hasDrained = 0; hasDrained < drain && (actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false)) > 0; hasDrained += actualDrain) {
                }
            }
        }
    }

    public void onExpire() {
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("xTile", (short)this.xTile);
        nbt.func_74777_a("yTile", (short)this.yTile);
        nbt.func_74777_a("zTile", (short)this.zTile);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        nbt.func_74768_a("inData", this.inData);
        nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        nbt.func_74778_a("bulletType", this.bulletType);
        if (!this.bulletPotion.func_190926_b()) {
            nbt.func_74782_a("bulletPotion", (NBTBase)this.bulletPotion.func_77955_b(new NBTTagCompound()));
        }
        if (this.shootingEntity != null) {
            nbt.func_74778_a("shootingEntity", this.shootingEntity.func_70005_c_());
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.xTile = nbt.func_74765_d("xTile");
        this.yTile = nbt.func_74765_d("yTile");
        this.zTile = nbt.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        this.inData = nbt.func_74762_e("inData");
        this.inGround = nbt.func_74771_c("inGround") == 1;
        this.bulletType = nbt.func_74779_i("bulletType");
        if (nbt.func_74764_b("bulletPotion")) {
            this.bulletPotion = new ItemStack(nbt.func_74775_l("bulletPotion"));
        }
        if (nbt.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150308_e(0);
            this.field_70181_x = nbttaglist.func_150308_e(1);
            this.field_70179_y = nbttaglist.func_150308_e(2);
        } else {
            this.func_70106_y();
        }
        if (this.field_70170_p != null) {
            this.shootingEntity = this.field_70170_p.func_72924_a(nbt.func_74779_i("shootingEntity"));
        }
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }
}

