/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileEntityFeedthrough
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPropertyPassthrough,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ICacheData {
    public static final String WIRE = "wire";
    private static final String POSITIVE_CON_X = "posConnX";
    private static final String POSITIVE_CON_Y = "posConnY";
    private static final String POSITIVE_CON_Z = "posConnZ";
    private static final String HAS_NEGATIVE = "hasNeg";
    private static final String FACING = "facing";
    private static final String OFFSET = "offset";
    public static final String MIDDLE_STATE = "middle";
    @Nonnull
    public WireType reference = WireType.COPPER;
    @Nonnull
    public IBlockState stateForMiddle = Blocks.field_150346_d.func_176223_P();
    @Nonnull
    EnumFacing facing = EnumFacing.NORTH;
    public int offset = 0;
    @Nullable
    private BlockPos connPositive = null;
    private boolean hasNegative = false;
    private boolean formed = true;
    private static float[] FULL_BLOCK = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private float[] aabb;

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74778_a(WIRE, this.reference.getUniqueName());
        if (this.connPositive != null) {
            nbt.func_74768_a(POSITIVE_CON_X, this.connPositive.func_177958_n());
            nbt.func_74768_a(POSITIVE_CON_Y, this.connPositive.func_177956_o());
            nbt.func_74768_a(POSITIVE_CON_Z, this.connPositive.func_177952_p());
        }
        nbt.func_74757_a(HAS_NEGATIVE, this.hasNegative);
        nbt.func_74768_a(FACING, this.facing.func_176745_a());
        nbt.func_74768_a(OFFSET, this.offset);
        NBTTagCompound stateNbt = new NBTTagCompound();
        Utils.stateToNBT(stateNbt, this.stateForMiddle);
        nbt.func_74782_a(MIDDLE_STATE, (NBTBase)stateNbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.reference = WireType.getValue(nbt.func_74779_i(WIRE));
        if (nbt.func_74764_b(POSITIVE_CON_X)) {
            this.connPositive = new BlockPos(nbt.func_74762_e(POSITIVE_CON_X), nbt.func_74762_e(POSITIVE_CON_Y), nbt.func_74762_e(POSITIVE_CON_Z));
        }
        this.hasNegative = nbt.func_74767_n(HAS_NEGATIVE);
        this.facing = EnumFacing.field_82609_l[nbt.func_74762_e(FACING)];
        this.offset = nbt.func_74762_e(OFFSET);
        this.stateForMiddle = Utils.stateFromNBT(nbt.func_74775_l(MIDDLE_STATE));
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return this.getOffset(con.start.equals((Object)this.connPositive) || con.end.equals((Object)this.connPositive));
    }

    private boolean isPositive(Vec3i offset) {
        return offset.func_177958_n() * this.facing.func_82601_c() + offset.func_177956_o() * this.facing.func_96559_d() + offset.func_177952_p() * this.facing.func_82599_e() > 0;
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getOffset(this.isPositive(offsetLink));
    }

    private Vec3d getOffset(boolean positive) {
        double l = WireApi.INFOS.get((Object)this.reference).connOffset;
        int factor = positive ? 1 : -1;
        return new Vec3d(0.5 + (0.5 + l) * (double)this.facing.func_82601_c() * (double)factor, 0.5 + (0.5 + l) * (double)this.facing.func_96559_d() * (double)factor, 0.5 + (0.5 + l) * (double)this.facing.func_82599_e() * (double)factor);
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (!WireApi.canMix(this.reference, cableType)) {
            return false;
        }
        boolean positive = this.isPositive(offset);
        if (positive) {
            return this.connPositive == null;
        }
        return !this.hasNegative;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other, @Nullable Vec3i offset) {
        if (offset != null) {
            if (this.isPositive(offset)) {
                this.connPositive = ApiUtils.toBlockPos(other);
            } else {
                this.hasNegative = true;
            }
        }
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        if (connection == null) {
            this.connPositive = null;
            this.hasNegative = false;
        } else if (connection.end.equals((Object)this.connPositive) || connection.start.equals((Object)this.connPositive)) {
            this.connPositive = null;
        } else {
            this.hasNegative = false;
        }
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.reference;
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.field_174879_c.func_177967_a(this.facing, 1), (Object)this.field_174879_c.func_177967_a(this.facing, -1));
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.field_174879_c.func_177967_a(this.facing, -this.offset);
    }

    @Override
    public NonNullList<ItemStack> getTileDrops(@Nullable EntityPlayer player, IBlockState state) {
        WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(this.reference);
        if (info.canReplace()) {
            if (this.offset == 0) {
                return Utils.getDrops(this.stateForMiddle);
            }
            assert (info.conn != null);
            return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack(info.conn.func_177230_c(), 1, info.conn.func_177230_c().func_176201_c(info.conn))});
        }
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        stack.func_77983_a(WIRE, (NBTBase)new NBTTagString(this.reference.getUniqueName()));
        NBTTagCompound stateNbt = new NBTTagCompound();
        Utils.stateToNBT(stateNbt, this.stateForMiddle);
        stack.func_77983_a(MIDDLE_STATE, (NBTBase)stateNbt);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack});
    }

    @Override
    public ItemStack getPickBlock(@Nullable EntityPlayer player, IBlockState state, RayTraceResult rayRes) {
        WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(this.reference);
        if (info.canReplace() && this.offset == 0) {
            try {
                return this.stateForMiddle.func_177230_c().getPickBlock(this.stateForMiddle, rayRes, this.field_145850_b, this.field_174879_c, player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getTileDrop(player, state);
    }

    @Override
    public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack) {
        this.reference = WireType.getValue(ItemNBTHelper.getString(stack, WIRE));
        this.stateForMiddle = Utils.stateFromNBT(ItemNBTHelper.getTagCompound(stack, MIDDLE_STATE));
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 1;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = -1; i <= 1; i += 2) {
            BlockPos tmp = pos.func_177967_a(this.facing, i);
            this.field_145850_b.func_175656_a(tmp, state);
            TileEntity te = this.field_145850_b.func_175625_s(tmp);
            if (!(te instanceof TileEntityFeedthrough)) continue;
            ((TileEntityFeedthrough)te).facing = this.facing;
            ((TileEntityFeedthrough)te).offset = i;
            ((TileEntityFeedthrough)te).reference = this.reference;
            ((TileEntityFeedthrough)te).stateForMiddle = this.stateForMiddle;
            this.field_145850_b.func_175664_x(tmp);
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (!this.formed) {
            return;
        }
        WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(this.reference);
        for (int i = -1; i <= 1; ++i) {
            int offsetLocal = i - this.offset;
            BlockPos replacePos = pos.func_177967_a(this.facing, offsetLocal);
            if (!info.canReplace()) {
                this.field_145850_b.func_175698_g(replacePos);
                continue;
            }
            if (i == this.offset) continue;
            TileEntity te = this.field_145850_b.func_175625_s(replacePos);
            if (te instanceof TileEntityFeedthrough) {
                ((TileEntityFeedthrough)te).formed = false;
            }
            IBlockState newState = Blocks.field_150350_a.func_176223_P();
            switch (i) {
                case -1: {
                    newState = info.conn.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.facing);
                    break;
                }
                case 0: {
                    newState = this.stateForMiddle;
                    break;
                }
                case 1: {
                    newState = info.conn.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)this.facing.func_176734_d());
                }
            }
            this.field_145850_b.func_175656_a(replacePos, newState);
        }
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.offset == 0) {
            return FULL_BLOCK;
        }
        if (this.aabb == null) {
            float[] tmp = new float[]{0.3125f, 0.0f, 0.3125f, 0.6875f, (float)WireApi.INFOS.get((Object)this.reference).connLength, 0.6875f};
            this.aabb = Utils.rotateToFacing(tmp, this.offset > 0 ? this.facing : this.facing.func_176734_d());
        }
        return this.aabb;
    }

    @Override
    public Object[] getCacheData() {
        return new Object[]{this.stateForMiddle, this.reference, this.facing};
    }

    @Override
    public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c) {
        return WireApi.INFOS.get((Object)this.reference).postProcessDmg.apply(Float.valueOf(super.getDamageAmount(e, c))).floatValue();
    }

    @Override
    protected float getBaseDamage(ImmersiveNetHandler.Connection c) {
        return WireApi.INFOS.get((Object)this.reference).dmgPerEnergy;
    }

    @Override
    protected float getMaxDamage(ImmersiveNetHandler.Connection c) {
        return WireApi.INFOS.get((Object)this.reference).maxDmg;
    }
}

