/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelItemDynamicOverride
implements IBakedModel {
    IBakedModel itemModel;
    ImmutableList<BakedQuad> quads;
    public static final HashMap<String, IBakedModel> modelCache = new HashMap();
    static ItemOverrideList dynamicOverrides = new ItemOverrideList(new ArrayList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IEItemInterfaces.ITextureOverride texOverride;
            String key;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IEItemInterfaces.ITextureOverride && (key = (texOverride = (IEItemInterfaces.ITextureOverride)stack.func_77973_b()).getModelCacheKey(stack)) != null) {
                IBakedModel model = modelCache.get(key);
                if (model == null) {
                    model = new ModelItemDynamicOverride(originalModel, texOverride.getTextures(stack, key));
                    modelCache.put(key, model);
                }
                return model;
            }
            return originalModel;
        }
    };

    public ModelItemDynamicOverride(IBakedModel itemModel, @Nullable List<ResourceLocation> textures) {
        this.itemModel = itemModel;
        if (textures != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Optional<TRSRTransformation> transform = Optional.of(TRSRTransformation.identity());
            for (int i = 0; i < textures.size(); ++i) {
                builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)ClientUtils.getSprite(textures.get(i)), (VertexFormat)DefaultVertexFormats.field_176599_b, transform));
            }
            this.quads = builder.build();
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (this.quads != null) {
            return this.quads;
        }
        return this.itemModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.itemModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.itemModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.itemModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.itemModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.itemModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return dynamicOverrides;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.itemModel.handlePerspective(cameraTransformType).getRight());
    }
}

