/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;

public class ShaderCaseMinecart
extends ShaderCase {
    public static Set<Class<? extends EntityMinecart>> invalidMinecartClasses = new HashSet<Class<? extends EntityMinecart>>();
    public boolean[][] renderSides;
    public boolean[] mirrorSideForPass;

    public ShaderCaseMinecart(ShaderCase.ShaderLayer ... layers) {
        super(layers);
        this.initBooleans();
    }

    public ShaderCaseMinecart(Collection<ShaderCase.ShaderLayer> layers) {
        super(layers);
        this.initBooleans();
    }

    @Override
    public ShaderCase addLayers(ShaderCase.ShaderLayer ... addedLayers) {
        ShaderCase sCase = super.addLayers(addedLayers);
        this.initBooleans();
        return sCase;
    }

    private void initBooleans() {
        this.mirrorSideForPass = new boolean[this.getLayers().length];
        this.renderSides = new boolean[this.getLayers().length][7];
        for (int i = 0; i < this.mirrorSideForPass.length; ++i) {
            this.mirrorSideForPass[i] = true;
            for (int j = 0; j < 7; ++j) {
                this.renderSides[i][j] = true;
            }
        }
    }

    @Override
    public String getShaderType() {
        return "immersiveengineering:minecart";
    }

    @Override
    public int getLayerInsertionIndex() {
        return this.layers.length - 1;
    }

    @Override
    public boolean stitchIntoSheet() {
        return false;
    }

    @Override
    public boolean renderModelPartForPass(ItemStack shader, ItemStack item, String modelPart, int pass) {
        return this.renderSides[pass][Integer.parseInt(modelPart)];
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre, boolean inventory) {
    }
}

