/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public abstract class TileEntityImmersiveConnectable
extends TileEntityIEBase
implements IImmersiveConnectable {
    protected WireType limitType = null;
    private List<Pair<Float, Consumer<Float>>> sources = new ArrayList<Pair<Float, Consumer<Float>>>();
    private long lastSourceUpdate = 0L;

    protected boolean canTakeLV() {
        return false;
    }

    protected boolean canTakeMV() {
        return false;
    }

    protected boolean canTakeHV() {
        return false;
    }

    protected boolean isRelay() {
        return false;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.func_174877_v();
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        boolean foundAccepting;
        String category = cableType.getCategory();
        boolean bl = foundAccepting = "HV".equals(category) && this.canTakeHV() || "MV".equals(category) && this.canTakeMV() || "LV".equals(category) && this.canTakeLV();
        if (!foundAccepting) {
            return false;
        }
        return this.limitType == null || this.isRelay() && WireApi.canMix(this.limitType, cableType);
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        this.limitType = cableType;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type = connection != null ? connection.cableType : null;
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this));
        if (!(outputs != null && outputs.size() != 0 || type != this.limitType && type != null)) {
            this.limitType = null;
        }
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public void addAvailableEnergy(float amount, Consumer<Float> consume) {
        long currentTime = this.field_145850_b.func_82737_E();
        if (this.lastSourceUpdate != currentTime) {
            this.sources.clear();
            Pair<Float, Consumer<Float>> own = this.getOwnEnergy();
            if (own != null) {
                this.sources.add(own);
            }
            this.lastSourceUpdate = currentTime;
        }
        if (amount > 0.0f && consume != null) {
            this.sources.add((Pair<Float, Consumer<Float>>)new ImmutablePair((Object)Float.valueOf(amount), consume));
        }
    }

    @Nullable
    protected Pair<Float, Consumer<Float>> getOwnEnergy() {
        return null;
    }

    @Override
    public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c) {
        int consume;
        float baseDmg = this.getBaseDamage(c);
        float max = this.getMaxDamage(c);
        if (baseDmg == 0.0f || this.field_145850_b.func_82737_E() - this.lastSourceUpdate > 1L) {
            return 0.0f;
        }
        float damage = 0.0f;
        for (int i = 0; i < this.sources.size() && damage < max; damage += baseDmg * (float)consume, ++i) {
            consume = (int)Math.min(((Float)this.sources.get(i).getLeft()).floatValue(), (max - damage) / baseDmg);
        }
        return damage;
    }

    @Override
    public void processDamage(Entity e, float amount, ImmersiveNetHandler.Connection c) {
        float baseDmg = this.getBaseDamage(c);
        float damage = 0.0f;
        for (int i = 0; i < this.sources.size() && damage < amount; ++i) {
            float consume = Math.min(((Float)this.sources.get(i).getLeft()).floatValue(), (amount - damage) / baseDmg);
            ((Consumer)this.sources.get(i).getRight()).accept(Float.valueOf(consume));
            damage += baseDmg * consume;
            if (consume != ((Float)this.sources.get(i).getLeft()).floatValue()) continue;
            this.sources.remove(i);
            --i;
        }
    }

    protected float getBaseDamage(ImmersiveNetHandler.Connection c) {
        if (c.cableType == WireType.COPPER) {
            return 16.0f / (float)c.cableType.getTransferRate();
        }
        if (c.cableType == WireType.ELECTRUM) {
            return 40.0f / (float)c.cableType.getTransferRate();
        }
        if (c.cableType == WireType.STEEL) {
            return 120.0f / (float)c.cableType.getTransferRate();
        }
        return 0.0f;
    }

    protected float getMaxDamage(ImmersiveNetHandler.Connection c) {
        return (float)(c.cableType.getTransferRate() / 8) * this.getBaseDamage(c);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_189515_b(nbttagcompound);
        this.writeConnsToNBT(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, nbttagcompound);
    }

    @Override
    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        this.loadConnsFromNBT(nbt);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == -1 || id == 255) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        if (id == 254) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state instanceof IExtendedBlockState) {
                state = state.func_185899_b((IBlockAccess)this.field_145850_b, this.func_174877_v());
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this.field_145850_b, this.func_174877_v());
                ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState)state);
                ImmersiveEngineering.proxy.removeStateFromConnectionModelCache((IExtendedBlockState)state);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        try {
            this.limitType = nbt.func_74764_b("limitType") ? ApiUtils.getWireTypeFromNBT(nbt, "limitType") : null;
            if (nbt.func_74764_b("connectionList")) {
                this.loadConnsFromNBT(nbt);
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error reading NBT. You should probably report this.");
            IELogger.logger.catching(Level.ERROR, (Throwable)e);
        }
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        try {
            if (this.limitType != null) {
                nbt.func_74778_a("limitType", this.limitType.getUniqueName());
            }
            if (descPacket) {
                this.writeConnsToNBT(nbt);
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error writing NBT. You should probably report this.");
            IELogger.logger.catching(Level.ERROR, (Throwable)e);
        }
    }

    private void loadConnsFromNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !Minecraft.func_71410_x().func_71356_B() && nbt != null) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC(this), this.field_145850_b);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.field_145850_b, Utils.toCC(this), con);
                    continue;
                }
                IELogger.error("CLIENT read connection as null from {}", nbt);
            }
        }
    }

    private void writeConnsToNBT(NBTTagCompound nbt) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && nbt != null) {
            NBTTagList connectionList = new NBTTagList();
            Set<ImmersiveNetHandler.Connection> conL = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.func_74742_a((NBTBase)con.writeToNBT());
                }
            }
            nbt.func_74782_a("connectionList", (NBTBase)connectionList);
        }
    }

    public Set<ImmersiveNetHandler.Connection> genConnBlockstate() {
        Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
        if (conns == null) {
            return ImmutableSet.of();
        }
        HashSet<ImmersiveNetHandler.Connection> ret = new HashSet<ImmersiveNetHandler.Connection>(){

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HashSet)) {
                    return false;
                }
                HashSet other = (HashSet)o;
                if (other.size() != this.size()) {
                    return false;
                }
                for (ImmersiveNetHandler.Connection c : this) {
                    if (other.contains(c)) continue;
                    return false;
                }
                return true;
            }
        };
        for (ImmersiveNetHandler.Connection c : conns) {
            IImmersiveConnectable end = ApiUtils.toIIC(c.end, this.field_145850_b, false);
            if (end == null) continue;
            c.getSubVertices(this.field_145850_b);
            ret.add(c);
        }
        return ret;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ImmersiveNetHandler.INSTANCE.addProxy(new IICProxy(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            Queue queue = this.field_145850_b.func_73046_m().field_175589_i;
            synchronized (queue) {
                this.field_145850_b.func_73046_m().field_175589_i.add(ListenableFutureTask.create(() -> ImmersiveNetHandler.INSTANCE.onTEValidated(this), null));
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
    }
}

