/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualInstance.ManualEntry;
import blusunrize.lib.manual.ManualInstance.ManualLink;
import blusunrize.lib.manual.ManualUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.*;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

import java.io.IOException;
import java.util.*;

public class GuiManual extends GuiScreen
{
	int xSize = 186;
	int ySize = 198;
	int guiLeft;
	int guiTop;
	int manualTick=0;
	List<GuiButton> pageButtons = new ArrayList();

	public String selectedCategory;
	private String selectedEntry;
	public Stack<String> previousSelectedEntry = new Stack();
	public int page;
	public static GuiManual activeManual;

	ManualInstance manual;
	String texture;
	String[] headers = new String[0];
	boolean buttonHeld = false;
	int[] lastClick;
	int[] lastDrag;
	GuiTextField searchField;
	int hasSuggestions = -1;
	String[] suggestionHeaders = new String[0];
	int prevGuiScale = -1;

	public GuiManual(ManualInstance manual, String texture)
	{
		super();
		this.manual = manual;
		this.texture = texture;

		prevGuiScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
		if(prevGuiScale!=0 && prevGuiScale!=2 && manual.allowGuiRescale())
			Minecraft.func_71410_x().field_71474_y.field_74335_Z=2;
		activeManual=this;
	}
	@Override
	public boolean func_73868_f()
	{
		return false;
	}

	public String getSelectedEntry()
	{
		return selectedEntry;
	}
	public void setSelectedEntry(String string)
	{
		selectedEntry = string;
		if(string!=null)
			manual.openEntry(string);
	}
	public ManualInstance getManual()
	{
		return this.manual;
	}

	@Override
	public void func_73866_w_()
	{
		if(Minecraft.func_71410_x().field_71474_y.field_74335_Z==1)
		{
			Minecraft.func_71410_x().field_71474_y.field_74335_Z=2;
			ScaledResolution res = new ScaledResolution(this.field_146297_k);
			this.field_146294_l = res.func_78326_a();
			this.field_146295_m = res.func_78328_b();
			Minecraft.func_71410_x().field_71474_y.field_74335_Z=1;
		}
		this.manual.openManual();

		guiLeft =  (this.field_146294_l - this.xSize) / 2;
		guiTop =  (this.field_146295_m - this.ySize) / 2;
		boolean textField = false;

		this.field_146292_n.clear();
		this.pageButtons.clear();
		headers=new String[0];
		suggestionHeaders=new String[0];
		hasSuggestions = -1;
		if(manual.getEntry(selectedEntry)!=null)
		{
			ManualEntry entry = manual.getEntry(selectedEntry);
			IManualPage mPage = (page<0||page>=entry.getPages().length)?null: entry.getPages()[page];
			if(mPage!=null)
				mPage.initPage(this, guiLeft+32,guiTop+28, pageButtons);
			field_146292_n.addAll(pageButtons);
		}
		else if(manual.getSortedCategoryList()==null||manual.getSortedCategoryList().length<=1)
		{
			ArrayList<String> lHeaders = new ArrayList<String>();
			for(ManualEntry e : manual.manualContents.values())
				if(manual.showEntryInList(e))
					lHeaders.add(e.getName());
			headers = lHeaders.toArray(new String[lHeaders.size()]);
			this.field_146292_n.add(new GuiClickableList(this, 0, guiLeft + 40, guiTop + 20, 100, 168, 1f, 1, headers));
			textField = true;
		}
		else if(manual.manualContents.containsKey(selectedCategory))
		{
			ArrayList<String> lHeaders = new ArrayList<String>();
			for(ManualEntry e : manual.manualContents.get(selectedCategory))
				if(manual.showEntryInList(e))
					lHeaders.add(e.getName());
			headers = lHeaders.toArray(new String[lHeaders.size()]);
			this.field_146292_n.add(new GuiClickableList(this, 0, guiLeft + 40, guiTop + 20, 100, 168, 1f, 1, headers));
			textField = true;
		}
		else
		{
			ArrayList<String> lHeaders = new ArrayList<String>();
			for(String cat : manual.getSortedCategoryList())
				if(manual.showCategoryInList(cat))
					lHeaders.add(cat);
			headers = lHeaders.toArray(new String[lHeaders.size()]);
			this.field_146292_n.add(new GuiClickableList(this, 0, guiLeft + 40, guiTop + 20, 100, 168, 1f, 0, headers));
			textField = true;
		}
		if(manual.manualContents.containsKey(selectedCategory) || manual.getEntry(selectedEntry)!=null)
			this.field_146292_n.add(new GuiButtonManualNavigation(this, 1, guiLeft+24,guiTop+10, 10,10, 0));

		if(textField)
		{
			Keyboard.enableRepeatEvents(true);
			searchField = new GuiTextField(99, this.field_146289_q, guiLeft+166, guiTop+78, 120, 12);
			searchField.func_146193_g(-1);
			searchField.func_146204_h(-1);
			searchField.func_146185_a(false);
			searchField.func_146203_f(17);
			searchField.func_146195_b(true);
			searchField.func_146205_d(false);
		}
		else if(searchField!=null)
			searchField = null;
	}

	@Override
	public void func_73863_a(int mx, int my, float f)
	{
		manualTick++;
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		boolean uni = manual.fontRenderer.func_82883_a();
		manual.fontRenderer.func_78264_a(true);
		manual.entryRenderPre();

		ManualUtils.bindTexture(texture);
		this.func_73729_b(guiLeft,guiTop, 0,0, xSize,ySize);
		if(this.searchField!=null)
		{
			int l = searchField.func_146179_b()!=null?searchField.func_146179_b().length()*6:0;
			if(l>20)
				this.func_73729_b(guiLeft+166,guiTop+74, 136+(120-l),238, l,18);
			if(this.hasSuggestions!=-1 && this.hasSuggestions<this.field_146292_n.size())
			{
				this.func_73729_b(guiLeft+174,guiTop+100, 214,212, 16,26);
				int h = ((GuiClickableList)this.field_146292_n.get(hasSuggestions)).getFontHeight() * Math.min( ((GuiClickableList)this.field_146292_n.get(hasSuggestions)).perPage, ((GuiClickableList)this.field_146292_n.get(hasSuggestions)).entries.length);
				int w = 76;
				this.func_73729_b(guiLeft+174,guiTop+116, 230,212, 16,16);//Top Left
				this.func_73729_b(guiLeft+174,guiTop+132+h, 230,228, 16,10);//Bottom Left
				this.func_73729_b(guiLeft+190+w,guiTop+116, 246,212, 10,16);//Top Right
				this.func_73729_b(guiLeft+190+w,guiTop+132+h, 246,228, 10,10);//Bottom Right
				for(int hh=0; hh<h; hh++)
				{
					this.func_73729_b(guiLeft+174,guiTop+132+hh, 230,228, 16,1);
					for(int ww=0; ww<w; ww++)
						this.func_73729_b(guiLeft+190+ww,guiTop+132+hh, 246,228, 1,1);
					this.func_73729_b(guiLeft+190+w,guiTop+132+hh, 246,228, 10,1);
				}
				for(int ww=0; ww<w; ww++)
				{
					this.func_73729_b(guiLeft+190+ww,guiTop+116, 246,212, 1,16);
					this.func_73729_b(guiLeft+190+ww,guiTop+132+h, 246,228, 1,10);

				}
			}
		}

		if(manual.getEntry(selectedEntry)!=null)
		{
			ManualEntry entry = manual.getEntry(selectedEntry);
			mx-=guiLeft;
			my-=guiTop;
			boolean b0 = mx>32&&mx<32+17 && my>179&&my<179+10;
			boolean b1 = mx>135&&mx<135+17 && my>179&&my<179+10;

			GL11.glEnable(GL11.GL_BLEND);
			if(page>0)
				this.func_73729_b(guiLeft+ 32,guiTop+179, 0,216+(b0?20:0), 16,10);
			if(page<entry.getPages().length-1)
				this.func_73729_b(guiLeft+136,guiTop+179, 0,226+(b1?20:0), 16,10);

			manual.titleRenderPre();
			//Title
			this.drawCenteredStringScaled(manual.fontRenderer, TextFormatting.BOLD+manual.formatEntryName(entry.getName()), guiLeft+xSize/2,guiTop+14, manual.getTitleColour(), 1, true);
			this.drawCenteredStringScaled(manual.fontRenderer, manual.formatEntrySubtext(entry.getName()), guiLeft+xSize/2,guiTop+22, manual.getSubTitleColour(), 1, true);
			//Page Number
			this.drawCenteredStringScaled(manual.fontRenderer, TextFormatting.BOLD.toString()+(page+1), guiLeft+xSize/2,guiTop+183, manual.getPagenumberColour(), 1, false);
			manual.titleRenderPost();

			GL11.glColor3f(1,1,1);
			IManualPage mPage = (page<0||page>=entry.getPages().length)?null: entry.getPages()[page];
			if(mPage!=null)
				mPage.renderPage(this, guiLeft+32,guiTop+28, mx+guiLeft,my+guiTop);

			mx+=guiLeft;
			my+=guiTop;
		}
		else
		{
			String title = manual.manualContents.containsKey(selectedCategory)?manual.formatCategoryName(selectedCategory) : manual.getManualName();
			manual.titleRenderPre();
			this.drawCenteredStringScaled(manual.fontRenderer, TextFormatting.BOLD+title, guiLeft+xSize/2,guiTop+12, manual.getTitleColour(), 1, true);
			manual.titleRenderPost();
		}
		if(this.searchField!=null)
		{
			manual.fontRenderer.func_78264_a(true);
			this.searchField.func_146194_f();
			if(this.hasSuggestions!=-1 && this.hasSuggestions<this.field_146292_n.size())
				manual.fontRenderer.func_175065_a("It looks like you meant:", guiLeft+180, guiTop+128, manual.getTextColour(), false);
		}
		manual.fontRenderer.func_78264_a(uni);
		super.func_73863_a(mx, my, f);
		GlStateManager.func_179147_l();
		manual.entryRenderPost();
	}

	@Override
	public void func_146281_b()
	{
		this.manual.closeManual();
		super.func_146281_b();
		if(prevGuiScale!=-1 && manual.allowGuiRescale())
			Minecraft.func_71410_x().field_71474_y.field_74335_Z = prevGuiScale;
	}

	@Override
	public void func_146284_a(GuiButton button)
	{
		if(buttonHeld)
			return;
		if(button.field_146127_k == 0)
		{
			int sel = ((GuiClickableList)button).selectedOption;
			if(sel>=0&&sel<headers.length)
			{
				if(((GuiClickableList)button).translationType==0)
					selectedCategory = headers[sel];
				else
				{
					previousSelectedEntry.clear();
					setSelectedEntry(headers[sel]);
				}
			}
			((GuiClickableList)button).selectedOption=-1;
			this.func_73866_w_();
		}
		else if(button.field_146127_k == 11)
		{
			int sel = ((GuiClickableList)button).selectedOption;
			if(sel>=0&&sel<suggestionHeaders.length)
				setSelectedEntry(suggestionHeaders[sel]);
			((GuiClickableList)button).selectedOption=-1;
			this.func_73866_w_();
		}
		else if(button.field_146127_k == 1)
		{
			if(selectedEntry!=null)
				setSelectedEntry(previousSelectedEntry.isEmpty()?null:previousSelectedEntry.pop());
			else if(selectedCategory!=null)
				selectedCategory=null;
			page=0;
			this.func_73866_w_();
		}
		else if(pageButtons.contains(button) && manual.getEntry(selectedEntry)!=null)
		{
			ManualEntry entry = manual.getEntry(selectedEntry);
			IManualPage mPage = (page<0||page>=entry.getPages().length)?null: entry.getPages()[page];
			if(mPage!=null)
				mPage.buttonPressed(this, button);
		}
		buttonHeld=true;
	}


	public void drawCenteredStringScaled(FontRenderer fr, String s, int x, int y, int colour, float scale, boolean shadow)
	{
		int xx = (int)Math.floor(x/scale - (fr.func_78256_a(s)/2));
		int yy = (int)Math.floor(y/scale - (fr.field_78288_b/2));
		if(scale!=1)
			GL11.glScalef(scale, scale, scale);
		fr.func_175065_a(s, xx,yy, colour, shadow);
		if(scale!=1)
			GL11.glScalef(1/scale, 1/scale, 1/scale);
	}

	@Override
	public void func_73733_a(int x1, int y1, int x2, int y2, int colour1, int colour2)
	{
		super.func_73733_a(x1, y1, x2, y2, colour1, colour2);
		GL11.glEnable(GL11.GL_BLEND);
	}
	@Override
	public void func_146285_a(ItemStack stack, int x, int y)
	{
		super.func_146285_a(stack, x, y);
	}
	@Override
	public List<String> func_191927_a(ItemStack stack)
	{
		List<String> tooltip = super.func_191927_a(stack);
		ManualEntry entry = manual.getEntry(selectedEntry);
		if(entry!=null)
		{
			IManualPage mPage = (page < 0||page >= entry.getPages().length)?null: entry.getPages()[page];
			if(mPage!=null && mPage.getHighlightedStack()==stack)
			{
				ManualLink link = this.manual.getManualLink(stack);
				if(link!=null)
					tooltip.add(manual.formatLink(link));
			}
		}
		return tooltip;
	}
	@Override
	public void drawHoveringText(List text, int x, int y, FontRenderer font)
	{
		manual.tooltipRenderPre();
		super.drawHoveringText(text,x,y,font);
		manual.tooltipRenderPost();
	}

	@Override
	public void func_146274_d() throws IOException
	{
		super.func_146274_d();
		int wheel = Mouse.getEventDWheel();
		if(wheel!=0 && manual.getEntry(selectedEntry)!=null)
		{
			ManualEntry entry = manual.getEntry(selectedEntry);
			if(wheel>0 && page>0)
			{
				page--;
				this.func_73866_w_();
			}
			else if(wheel<0 && page<entry.getPages().length-1)
			{
				page++;
				this.func_73866_w_();
			}
		}
	}
	@Override
	public void func_73864_a(int mx, int my, int button) throws IOException
	{
		super.func_73864_a(mx,my,button);
		if(button==0 && manual.getEntry(selectedEntry)!=null)
		{
			ManualEntry entry = manual.getEntry(selectedEntry);
			mx -= guiLeft;
			my -= guiTop;
			if(page>0 && mx>32&&mx<32+17 && my>179&&my<179+10)
			{
				page--;
				this.func_73866_w_();
			}
			else if(page<entry.getPages().length-1 && mx>135&&mx<135+17 && my>179&&my<179+10)
			{
				page++;
				this.func_73866_w_();
			}
			else
			{
				IManualPage mPage = (page<0||page>=entry.getPages().length)?null: entry.getPages()[page];
				if(mPage!=null)
				{
					ItemStack highlighted = mPage.getHighlightedStack();
					if(!highlighted.func_190926_b())
					{
						ManualLink link = this.getManual().getManualLink(highlighted);
						if(link!=null)
							link.changePage(this);
					}
				}
			}
		}
		else if(button==1)
		{
			if(searchField!=null && searchField.func_146179_b()!=null && !searchField.func_146179_b().isEmpty())
				searchField.func_146180_a("");
			else if(selectedEntry!=null)
				setSelectedEntry(previousSelectedEntry.isEmpty()?null:previousSelectedEntry.pop());
			else if(selectedCategory!=null)
				selectedCategory=null;
			page=0;
			this.func_73866_w_();
		}
		lastClick = new int[]{mx,my};
		if(this.searchField!=null)
			this.searchField.func_146192_a(mx, my, button);
	}
	@Override
	protected void func_146286_b(int mx, int my, int action)
	{
		super.func_146286_b(mx, my, action);
		if(buttonHeld && (action==0||action==1))
			buttonHeld=false;
		lastClick = null;
		lastDrag = null;
	}
	@Override
	protected void func_146273_a(int mx, int my, int button, long time)
	{
		if(lastClick!=null && manual.getEntry(selectedEntry)!=null && page<manual.getEntry(selectedEntry).getPages().length)
		{
			ManualEntry entry = manual.getEntry(selectedEntry);
			if(lastDrag==null)
				lastDrag = new int[]{mx-guiLeft,my-guiTop};
			entry.getPages()[page].mouseDragged(guiLeft+32,guiTop+28, lastClick[0],lastClick[1], mx-guiLeft,my-guiTop, lastDrag[0],lastDrag[1], button);
			lastDrag = new int[]{mx-guiLeft,my-guiTop};
		}
	}
	@Override
	protected void func_73869_a(char c, int i) throws IOException
	{
		if(this.searchField!=null && this.searchField.func_146201_a(c, i))
		{
			String search = searchField.func_146179_b();
			if(search==null || search.trim().isEmpty())
			{
				hasSuggestions = -1;
				this.func_73866_w_();
			}
			else
			{
				search = search.toLowerCase(Locale.ENGLISH);
				ArrayList<String> lHeaders = new ArrayList<String>();
				HashMap<String, String> lSpellcheck = new HashMap<String, String>();
				for(ManualEntry e : manual.manualContents.values())
				{
					if(manual.showEntryInList(e))
					{
						if(manual.formatEntryName(e.getName()).toLowerCase(Locale.ENGLISH).contains(search))
							lHeaders.add(e.getName());
						else
							lSpellcheck.put(manual.formatEntryName(e.getName()), e.getName());
					}
				}
				ArrayList<String> lCorrections = ManualUtils.getPrimitiveSpellingCorrections(search, lSpellcheck.keySet().toArray(new String[lSpellcheck.keySet().size()]), 4);
				for(String key : lSpellcheck.keySet())
					if(!lCorrections.contains(key))
					{
						ManualEntry e = manual.getEntry(lSpellcheck.get(key));
						for(IManualPage page : e.getPages())
							if(page.listForSearch(search))
							{
								lHeaders.add(e.getName());
								break;
							}
					}

				headers = lHeaders.toArray(new String[lHeaders.size()]);
				this.field_146292_n.set(0, new GuiClickableList(this, 0, guiLeft+40,guiTop+20, 100,148, 1f, 1, headers));
				if(!lCorrections.isEmpty())
				{
					GuiClickableList suggestions = new GuiClickableList(this, 11, guiLeft+180,guiTop+138, 100,80, 1f, -1, lCorrections.toArray(new String[0]));
					if(hasSuggestions!=-1)
						this.field_146292_n.set(hasSuggestions, suggestions);
					else
					{
						hasSuggestions = this.field_146292_n.size();
						this.field_146292_n.add(suggestions);
					}
					this.suggestionHeaders = new String[lCorrections.size()];
					for(int j=0; j<this.suggestionHeaders.length; j++)
						this.suggestionHeaders[j] = lSpellcheck.get(lCorrections.get(j));
				}
				else if(hasSuggestions!=-1)
				{
					this.field_146292_n.remove(hasSuggestions);
					hasSuggestions = -1;
				}
			}
		}
		else
		{
			super.func_73869_a(c, i);
		}
	}

}
