/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.lib.manual.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiClickableList extends GuiButton
{
	String[] entries;
	float textScale;
	int offset;
	int maxOffset;
	int perPage;
	int translationType;
	GuiManual gui;

	private long prevWheelNano = 0;

	public GuiClickableList(GuiManual gui, int id, int x, int y, int w, int h, float textScale, int translationType, String... entries)
	{
		super(id, x, y, w, h, "");
		this.gui = gui;
		this.textScale = textScale;
		this.entries = entries;
		this.translationType = translationType;

		perPage = (h-8)/getFontHeight();
		if(perPage<entries.length)
			maxOffset = entries.length-perPage;
	}

	int getFontHeight()
	{
		return (int) (gui.manual.fontRenderer.field_78288_b*textScale);
	}
	@Override
	public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks)
	{
		FontRenderer fr = gui.manual.fontRenderer;
		boolean uni = fr.func_82883_a();
		fr.func_78264_a(true);

		int mmY = my-this.field_146129_i;
		GlStateManager.func_179094_E();
		GlStateManager.func_179152_a(textScale, textScale, textScale);
		GlStateManager.func_179109_b(field_146128_h/textScale, field_146129_i/textScale, 0);
		GlStateManager.func_179124_c(1, 1, 1);
		this.field_146123_n = mx>=field_146128_h&&mx<field_146128_h+field_146120_f && my>=field_146129_i&&my<field_146129_i+field_146121_g;
		for(int i=0; i<Math.min(perPage, entries.length); i++)
		{
			int col = gui.manual.getTextColour();
			if(field_146123_n && mmY>=i*getFontHeight() && mmY<(i+1)*getFontHeight())
				col = gui.manual.getHighlightColour();
			if(i!=0)
				GlStateManager.func_179109_b(0, getFontHeight(), 0);
			int j = offset+i;
			if(j>entries.length-1)
				j=entries.length-1;
			String s = translationType==-1?entries[j]: translationType==0?gui.manual.formatCategoryName(entries[j]):gui.manual.formatEntryName(entries[j]);
			fr.func_175065_a(s, 0,0, col, false);
		}
		GlStateManager.func_179152_a(1/textScale,1/textScale,1/textScale);
		GlStateManager.func_179121_F();
		if(maxOffset>0)
		{
			int h1 = offset*getFontHeight();
			int h2 = field_146121_g-8-maxOffset*getFontHeight();
			this.func_73733_a(field_146128_h+field_146120_f, field_146129_i+h1, field_146128_h+field_146120_f+8, field_146129_i+h1+h2, 0x0a000000, 0x0a000000);
			this.func_73733_a(field_146128_h+field_146120_f+1, field_146129_i+h1, field_146128_h+field_146120_f+6, field_146129_i+h1+h2, 0x28000000, 0x28000000);
			if(offset > 0)
				this.func_73733_a(field_146128_h+field_146120_f, field_146129_i, field_146128_h+field_146120_f+8, field_146129_i+h1, 0x0a000000, 0x0a000000);
			if(offset < maxOffset)
			{
				int h3 = (maxOffset-offset)*getFontHeight();
				this.func_73733_a(field_146128_h+field_146120_f, field_146129_i+field_146121_g-8-h3, field_146128_h+field_146120_f+8, field_146129_i+field_146121_g-8, 0x0a000000, 0x11000000);
			}
		}

		fr.func_78264_a(uni);

		//Handle DWheel
		int mouseWheel = Mouse.getEventDWheel();
		if(mouseWheel!=0 && maxOffset>0 && Mouse.getEventNanoseconds()!=prevWheelNano)
		{
			prevWheelNano = Mouse.getEventNanoseconds();
			if(mouseWheel<0 && offset<maxOffset)
				offset++;
			if(mouseWheel>0 && offset>0)
				offset--;
		}
	}

	public int selectedOption=-1;
	@Override
	public boolean func_146116_c(Minecraft mc, int mx, int my)
	{
		boolean b = super.func_146116_c(mc, mx, my);
		selectedOption=-1;
		if(b)
		{
			int mmY = my-this.field_146129_i;
			for(int i=0; i<Math.min(perPage, entries.length); i++)
				if(mmY>=i*getFontHeight() && mmY<(i+1)*getFontHeight())
					selectedOption=offset+i;
		}
		return selectedOption!=-1;
	}
}
