/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualInstance.ManualLink;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

import java.util.Collections;

public class GuiButtonManualLink extends GuiButton
{
	public String localized;
	public ManualLink link;
	GuiManual gui;
	public GuiButtonManualLink(GuiManual gui, int id, int x, int y, int w, int h, ManualLink link, String localized)
	{
		super(id, x,y, w,h, "");
		this.gui = gui;
		this.link = link;
		this.localized = localized;
		if(gui.manual.improveReadability())
			this.localized = TextFormatting.BOLD+localized;
	}

	@Override
    public boolean func_146116_c(Minecraft mc, int mx, int my)
    {
        return super.func_146116_c(mc, mx, my);
    }

	@Override
	public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks)
	{
		this.field_146123_n = mx >= this.field_146128_h && my >= this.field_146129_i && mx < this.field_146128_h + this.field_146120_f && my < this.field_146129_i + this.field_146121_g;
		if(field_146123_n)
		{
//			FontRenderer font = gui.manual.fontRenderer;
			FontRenderer font = mc.field_71466_p;
			boolean uni = font.func_82883_a();
			font.func_78264_a(true);
			font.func_78276_b(localized, field_146128_h, field_146129_i, gui.manual.getHighlightColour());
			font.func_78264_a(false);
			gui.drawHoveringText(Collections.singletonList(gui.manual.formatLink(link)), mx+8,my+4, font);
			font.func_78264_a(uni);
			GlStateManager.func_179147_l();
		}
		
	}
}
