/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class GuiButtonManual extends GuiButton
{
	public GuiManual gui;
	public int[] colour = {0x33000000,0x33cb7f32};
	public int[] textColour = {0xffe0e0e0,0xffffffa0};
	public GuiButtonManual(GuiManual gui, int id, int x, int y, int w, int h, String text)
	{
		super(id, x, y, w, h, text);
		this.gui = gui;
	}
	public GuiButtonManual setColour(int normal, int hovered)
	{
		colour = new int[]{normal,hovered};
		return this;
	}
	public GuiButtonManual setTextColour(int normal, int hovered)
	{
		textColour = new int[]{normal,hovered};
		return this;
	}

	@Override
	public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks)
	{
		if (this.field_146125_m)
		{
			ManualUtils.bindTexture(gui.texture);
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			this.field_146123_n = mx>=this.field_146128_h&&mx<(this.field_146128_h+this.field_146120_f) && my>=this.field_146129_i&&my<(this.field_146129_i+this.field_146121_g);
			GL11.glEnable(GL11.GL_BLEND);
			OpenGlHelper.func_148821_a(770, 771, 1, 0);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

			int col = colour[field_146123_n?1:0];
			this.func_73733_a(field_146128_h,field_146129_i, field_146128_h+field_146120_f,field_146129_i+field_146121_g, col,col);
			int txtCol = textColour[field_146123_n?1:0];
			boolean uni = gui.manual.fontRenderer.func_82883_a();
			gui.manual.fontRenderer.func_78264_a(true);
			int sw = gui.manual.fontRenderer.func_78256_a(field_146126_j);
			gui.manual.fontRenderer.func_78276_b(field_146126_j, field_146128_h+field_146120_f/2-sw/2, field_146129_i+field_146121_g/2-gui.manual.fontRenderer.field_78288_b/2, txtCol);
			gui.manual.fontRenderer.func_78264_a(uni);
			this.func_146119_b(mc, mx, my);
		}
	}
}
