/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.Config.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoor.EnumHingePosition;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSlab.EnumBlockHalf;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces.PieceWeight;
import net.minecraft.world.gen.structure.StructureVillagePieces.Start;
import net.minecraft.world.gen.structure.StructureVillagePieces.Village;
import net.minecraftforge.fml.common.registry.VillagerRegistry.IVillageCreationHandler;
import net.minecraftforge.fml.common.registry.VillagerRegistry.VillagerProfession;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class VillageEngineersHouse extends Village
{
	public static ResourceLocation woodenCrateLoot = new ResourceLocation(ImmersiveEngineering.MODID, "chests/engineers_house");
	public VillageEngineersHouse()
	{
	}
	public VillageEngineersHouse(Start villagePiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, EnumFacing facing)
	{
		super(villagePiece, par2);
		this.func_186164_a(facing);
		this.field_74887_e = par4StructureBoundingBox;
	}

	static List<BlockPos> framesHung = new ArrayList();
	private int groundLevel = -1;
	@Override
	public boolean func_74875_a(World world, Random rand, StructureBoundingBox box)
	{
		if(groundLevel < 0)
		{
			groundLevel = this.func_74889_b(world, box);
			if(groundLevel<0)
				return true;
			field_74887_e.func_78886_a(0, groundLevel - field_74887_e.field_78894_e+10-1, 0);
		}

		//Clear Space
		this.func_175804_a(world, box, 0,0,0, 10,9,8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
		//Cobble
		this.func_175804_a(world, box, 1,0,1, 9,0,8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
		this.func_175804_a(world, box, 6,0,1, 9,0,2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
		//Stair
		this.func_175811_a(world, Blocks.field_150446_ar.func_176223_P().func_177226_a(BlockStairs.field_176309_a,EnumFacing.NORTH), 4,0,0, box);

		//Pillars
		this.func_175804_a(world, box, 1,1,3, 1,4,3, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);
		this.func_175804_a(world, box, 1,1,8, 1,6,8, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);
		this.func_175804_a(world, box, 9,1,3, 9,6,3, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);
		this.func_175804_a(world, box, 9,1,8, 9,6,8, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);
		this.func_175804_a(world, box, 1,4,3, 9,4,8, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);
		this.func_175804_a(world, box, 6,5,3, 6,7,3, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);
		this.func_175804_a(world, box, 1,5,5, 1,6,5, IEContent.blockTreatedWood.func_176223_P(), IEContent.blockTreatedWood.func_176223_P(), false);

		this.func_175804_a(world, box, 2,4,5, 8,4,7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);

		//Wool
		this.func_175804_a(world, box, 2,0,3, 5,0,4, Blocks.field_150325_L.func_176203_a(13), Blocks.field_150325_L.func_176203_a(13), false);
		this.func_175804_a(world, box, 2,0,4, 8,0,7, Blocks.field_150325_L.func_176203_a(13), Blocks.field_150325_L.func_176203_a(13), false);
		this.func_175804_a(world, box, 6,4,4, 8,4,4, Blocks.field_150325_L.func_176203_a(13), Blocks.field_150325_L.func_176203_a(13), false);
		this.func_175804_a(world, box, 2,4,5, 7,4,5, Blocks.field_150325_L.func_176203_a(13), Blocks.field_150325_L.func_176203_a(13), false);
		this.func_175804_a(world, box, 2,4,6, 6,4,6, Blocks.field_150325_L.func_176203_a(13), Blocks.field_150325_L.func_176203_a(13), false);
		this.func_175804_a(world, box, 2,4,7, 4,4,7, Blocks.field_150325_L.func_176203_a(13), Blocks.field_150325_L.func_176203_a(13), false);

		//Walls
		//Front
		this.func_175804_a(world, box, 2,1,3, 8,3,3, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 7,5,3, 8,6,3, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175811_a(world, Blocks.field_150344_f.func_176223_P(), 7,7,3, box);
		this.func_175804_a(world, box, 6,5,4, 6,7,4, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 2,5,5, 5,6,5, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 3,7,5, 5,7,5, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175811_a(world, Blocks.field_150344_f.func_176223_P(), 5,8,5, box);
		//Back
		this.func_175804_a(world, box, 2,1,8, 8,3,8, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 2,5,8, 8,6,8, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 3,7,8, 7,7,8, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175811_a(world, Blocks.field_150344_f.func_176223_P(), 5,8,8, box);
		//Left
		this.func_175804_a(world, box, 1,1,4, 1,3,7, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 1,5,6, 1,5,7, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		//Right
		this.func_175804_a(world, box, 9,1,4, 9,3,7, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);
		this.func_175804_a(world, box, 9,5,4, 9,6,7, Blocks.field_150344_f.func_176223_P(),Blocks.field_150344_f.func_176223_P(), false);

		//Windows
		//Front
		this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 2,2,3, box);
		this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 6,2,3, box);
		this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), 8,2,3, box);
		this.func_175804_a(world, box, 7,6,3, 8,6,3, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		//Back
		this.func_175804_a(world, box, 3,2,8, 5,2,8, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		this.func_175804_a(world, box, 3,6,8, 4,6,8, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		this.func_175804_a(world, box, 6,6,8, 7,6,8, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		//Left
		this.func_175804_a(world, box, 1,2,5, 1,2,6, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		this.func_175804_a(world, box, 1,6,6, 1,6,7, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		//Right
		this.func_175804_a(world, box, 9,2,5, 9,2,6, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);
		this.func_175804_a(world, box, 9,6,5, 9,6,6, Blocks.field_150410_aZ.func_176223_P(),Blocks.field_150410_aZ.func_176223_P(), false);

		//Fences
		this.func_175804_a(world, box, 1,1,1, 1,1,2, IEContent.blockWoodenDecoration.func_176203_a(0),IEContent.blockWoodenDecoration.func_176203_a(0), false);
		this.func_175804_a(world, box, 2,1,1, 3,1,1, IEContent.blockWoodenDecoration.func_176203_a(0),IEContent.blockWoodenDecoration.func_176203_a(0), false);
		this.func_175804_a(world, box, 5,1,1, 5,1,2, IEContent.blockWoodenDecoration.func_176203_a(0),IEContent.blockWoodenDecoration.func_176203_a(0), false);
		this.func_175804_a(world, box, 1,5,3, 1,5,4, IEContent.blockWoodenDecoration.func_176203_a(0),IEContent.blockWoodenDecoration.func_176203_a(0), false);
		this.func_175804_a(world, box, 2,5,3, 5,5,3, IEContent.blockWoodenDecoration.func_176203_a(0),IEContent.blockWoodenDecoration.func_176203_a(0), false);
		this.func_175804_a(world, box, 7,1,6, 7,5,6, IEContent.blockWoodenDecoration.func_176203_a(0),IEContent.blockWoodenDecoration.func_176203_a(0), false);

		//Doors
		this.func_189915_a(world, box, rand, 4, 1, 3, EnumFacing.NORTH, Blocks.field_180413_ao);
		if(func_186165_e()==EnumFacing.SOUTH || func_186165_e()==EnumFacing.WEST)
		{
			this.placeDoor(world, box, rand, 3,5,5, EnumFacing.NORTH, EnumHingePosition.LEFT);
			this.placeDoor(world, box, rand, 4,5,5, EnumFacing.NORTH, EnumHingePosition.RIGHT);
		}
		else
		{
			this.placeDoor(world, box, rand, 3,5,5, EnumFacing.NORTH, EnumHingePosition.LEFT);
			this.placeDoor(world, box, rand, 4,5,5, EnumFacing.NORTH, EnumHingePosition.RIGHT);
		}

		//Lanterns
		this.placeLantern(world, box, 5,3,6, 0);
		this.placeLantern(world, box, 5,7,6, 0);

		//Stairs
		IBlockState stairs = Blocks.field_150476_ad.func_176223_P().func_177226_a(BlockStairs.field_176309_a, EnumFacing.NORTH);
		func_175811_a(world, stairs, 8,1,6, box);
		stairs = stairs.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
//		stairMeta = this.getMetadataWithOffset(Blocks.OAK_STAIRS, 1);
		func_175811_a(world, Blocks.field_150344_f.func_176223_P(), 8,1,7, box);
		func_175811_a(world, stairs, 7,2,7, box);
		func_175811_a(world, stairs, 6,3,7, box);
		func_175811_a(world, stairs, 5,4,7, box);

		//Roof
		IBlockState brickSlab = Blocks.field_150333_U.func_176223_P().func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.BRICK);
		IBlockState brickSlabInverted = brickSlab.func_177226_a(BlockSlab.field_176554_a, EnumBlockHalf.TOP);
		this.func_175804_a(world, box, 0,6,4, 0,6,8, brickSlabInverted,brickSlabInverted, false);
		this.func_175804_a(world, box, 1,7,4, 1,7,8, brickSlab,brickSlab, false);
		this.func_175804_a(world, box, 3,8,4, 3,8,8, brickSlab,brickSlab, false);
		this.func_175804_a(world, box, 5,9,2, 5,9,8, brickSlab,brickSlab, false);
		this.func_175804_a(world, box, 7,8,2, 7,8,8, brickSlab,brickSlab, false);
		this.func_175804_a(world, box, 9,7,2, 9,7,8, brickSlab,brickSlab, false);
		this.func_175804_a(world, box, 10,6,2, 10,6,8, brickSlabInverted,brickSlabInverted, false);

		IBlockState brickStairs = Blocks.field_150389_bf.func_176223_P().func_177226_a(BlockStairs.field_176309_a, EnumFacing.EAST);
		this.func_175804_a(world, box, 2,7,4, 2,7,8, brickStairs,brickStairs, false);
		this.func_175804_a(world, box, 4,8,4, 4,8,8, brickStairs,brickStairs, false);
		brickStairs = brickStairs.func_185907_a(Rotation.CLOCKWISE_180);
		this.func_175804_a(world, box, 6,8,2, 6,8,8, brickStairs,brickStairs, false);
		this.func_175804_a(world, box, 8,7,2, 8,7,8, brickStairs,brickStairs, false);

		this.func_175804_a(world, box, 2,7,5, 2,8,5, Blocks.field_150336_V.func_176223_P(),Blocks.field_150336_V.func_176223_P(), false);
		this.func_175804_a(world, box, 7,8,4, 7,9,4, Blocks.field_150336_V.func_176223_P(),Blocks.field_150336_V.func_176223_P(), false);


		//Details
		try{
			this.placeCrate(world,box,rand, 6,0,1);
			this.placeCrate(world,box,rand, 8,0,2);
			this.placeCrate(world,box,rand, 5,1,7);
			this.placeItemframe(rand, world, 4,3,2, func_186165_e().func_176734_d(), new ItemStack(IEContent.itemTool,1,0));
		}catch(Exception e)
		{
			e.printStackTrace();
		}

		for(int zz=0; zz<=9; zz++)
			for(int xx=0; xx<=10; xx++)
			{
				this.func_74871_b(world, xx,10,zz, box);
				this.func_175808_b(world, Blocks.field_150347_e.func_176223_P(), xx, -1,zz, box);
			}

		if(IEConfig.enableVillagers)
			this.func_74893_a(world, box, 4, 1, 2, 1);
		return true;
	}

	protected boolean placeCrate(World world, StructureBoundingBox box, Random rand, int x, int y, int z)
	{
		int i1 = this.func_74865_a(x, z);
		int j1 = this.func_74862_a(y);
		int k1 = this.func_74873_b(x, z);
		BlockPos pos = new BlockPos(i1,j1,k1);
		if(box.func_175898_b(pos) && (world.func_180495_p(pos)!=IEContent.blockWoodenDevice0.func_176203_a(0)))
		{
			world.func_180501_a(pos, IEContent.blockWoodenDevice0.func_176203_a(0), 2);
			TileEntity tile = world.func_175625_s(pos);
			if(tile instanceof TileEntityWoodenCrate)
				((TileEntityWoodenCrate)tile).lootTable = woodenCrateLoot;
			return true;
		}
		else
			return false;
	}

	protected void placeDoor(World worldIn, StructureBoundingBox boundingBoxIn, Random rand, int x, int y, int z, EnumFacing facing, EnumHingePosition hinge)
	{
		this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176223_P().func_177226_a(BlockDoor.field_176520_a, facing).func_177226_a(BlockDoor.field_176521_M, hinge), x, y, z, boundingBoxIn);
		this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176223_P().func_177226_a(BlockDoor.field_176520_a, facing).func_177226_a(BlockDoor.field_176523_O, BlockDoor.EnumDoorHalf.UPPER).func_177226_a(BlockDoor.field_176521_M, hinge), x, y + 1, z, boundingBoxIn);
	}

	protected boolean placeLantern(World world, StructureBoundingBox box, int x, int y, int z, int facing)
	{
		int i1 = this.func_74865_a(x, z);
		int j1 = this.func_74862_a(y);
		int k1 = this.func_74873_b(x, z);
		BlockPos pos = new BlockPos(i1,j1,k1);
		//			world.setBlock(pos, IEContent.blockMetalDecoration0,BlockMetalDecoration1.META_lantern, 2);
//			TileEntity tile = world.getTileEntity(pos);
//			if(tile instanceof TileEntityLantern)
//				((TileEntityLantern)tile).facing = facing;
		return box.func_175898_b(pos);
	}
	public void placeItemframe(Random random, World world, int x, int y, int z, EnumFacing side, ItemStack stack)
	{
		int i1 = this.func_74865_a(x, z);
		int j1 = this.func_74862_a(y);
		int k1 = this.func_74873_b(x, z);

		EntityItemFrame e = new EntityItemFrame(world, new BlockPos(i1,j1,k1), side);
		e.func_82334_a(stack);
		if(e.func_70518_d() && world.func_72872_a(EntityHanging.class, new AxisAlignedBB(i1-.125,j1,k1-.125,i1+1.125,j1+1,k1+1.125)).isEmpty())
			if(!world.field_72995_K)
				world.func_72838_d(e);
	}

	@Override
	protected VillagerProfession chooseForgeProfession(int count, net.minecraftforge.fml.common.registry.VillagerRegistry.VillagerProfession prof)
	{
		return IEContent.villagerProfession_engineer;
	}
//	protected int func_180779_c(int i, int previousProfession)
//	{
//		//Changed to return Smith while Engineers don't exist
//		return 3;
//		//return Config.getInt("villager_engineer");
//	}

	public static class VillageManager implements IVillageCreationHandler
	{
		@Override
		public Village buildComponent(PieceWeight villagePiece, Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5)
		{
			StructureBoundingBox box = StructureBoundingBox.func_175897_a(p1, p2, p3, 0, 0, 0, 11, 10, 9, facing);
			return (!func_74895_a(box)) || (StructureComponent.func_74883_a(pieces, box) != null) ? null : new VillageEngineersHouse(startPiece, p5, random, box, facing);
		}
		@Override
		public PieceWeight getVillagePieceWeight(Random random, int i)
		{
			return new PieceWeight(VillageEngineersHouse.class, 15, MathHelper.func_76136_a(random, 0 + i, 1 + i));
		}
		@Override
		public Class<?> getComponentClass()
		{
			return VillageEngineersHouse.class;
		}
	}
}
