/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces.ISoundTile;
import blusunrize.immersiveengineering.common.items.ItemEarmuffs;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

import javax.annotation.Nullable;
import java.util.Iterator;

import net.minecraft.client.audio.ISound.AttenuationType;

public class IETileSound implements ITickableSound
{
	protected Sound sound;
	private SoundEventAccessor soundEvent;
	private SoundCategory category;
	public AttenuationType attenuation;
	public final ResourceLocation resource;
	public float volume;
	public float pitch;

	public int tileX;
	public int tileY;
	public int tileZ;
	public boolean canRepeat;
	public int repeatDelay;
	public float volumeAjustment=1;


	public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, AttenuationType attenuation, SoundCategory category)
	{
		this(event.func_187503_a(), volume, pitch, repeat, repeatDelay, x, y, z, attenuation, category);
	}
	public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, int x, int y, int z, AttenuationType attenuation, SoundCategory category)
	{
		this.attenuation = attenuation;
		this.resource = sound;
		this.volume = volume;
		this.pitch = pitch;
		this.tileX = x;
		this.tileY = y;
		this.tileZ = z;
		this.canRepeat = repeat;
		this.repeatDelay = repeatDelay;
		origPos = new float[]{(float)x,(float)y,(float)z};
		this.category = category;
	}
	public IETileSound(SoundEvent event, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, AttenuationType attenuation, SoundCategory category)
	{
		this(event.func_187503_a(), volume, pitch, repeat, repeatDelay, pos.func_177958_n(),pos.func_177956_o(),pos.func_177952_p(), attenuation, category);
	}
	public IETileSound(ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, BlockPos pos, AttenuationType attenuation, SoundCategory category)
	{
		this(sound, volume, pitch, repeat, repeatDelay, pos.func_177958_n(),pos.func_177956_o(),pos.func_177952_p(), attenuation, category);
	}

	public float[] origPos;

	@Override
	public AttenuationType func_147656_j()
	{
		return attenuation;
	}
	@Override
	public ResourceLocation func_147650_b()
	{
		return resource;
	}

	@Nullable
	@Override
	public SoundEventAccessor func_184366_a(SoundHandler handler)
	{
		this.soundEvent = handler.func_184398_a(this.resource);
		if(this.soundEvent == null)
			this.sound = SoundHandler.field_147700_a;
		else
			this.sound = this.soundEvent.func_148720_g();
		return this.soundEvent;
	}
	@Override
	public Sound func_184364_b()
	{
		return sound;
	}
	@Override
	public SoundCategory func_184365_d()
	{
		return category;
	}

	@Override
	public float func_147653_e()
	{
		return volume*volumeAjustment;
	}
	@Override
	public float func_147655_f()
	{
		return pitch;
	}
	@Override
	public float func_147649_g()
	{
		return tileX;
	}
	@Override
	public float func_147654_h()
	{
		return tileY;
	}
	@Override
	public float func_147651_i()
	{
		return tileZ;
	}
	@Override
	public boolean func_147657_c()
	{
		return canRepeat;
	}
	@Override
	public int func_147652_d()
	{
		return repeatDelay;
	}

	//	public void setPos(float x, float y, float z)
	//	{
	//		this.tileX=x;
	//		this.tileY=y;
	//		this.tileZ=z;
	//	}

	public void evaluateVolume()
	{
		volumeAjustment=1f;
		if(ClientUtils.mc().field_71439_g!=null && !ClientUtils.mc().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())
		{
			ItemStack stack = ClientUtils.mc().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
			if(ItemNBTHelper.hasKey(stack,"IE:Earmuffs"))
				stack = ItemNBTHelper.getItemStack(stack, "IE:Earmuffs");
			if(!stack.func_190926_b() && IEContent.itemEarmuffs.equals(stack.func_77973_b()))
				volumeAjustment = ItemEarmuffs.getVolumeMod(stack);
		}
		if(volumeAjustment>.1f)
			for(int dx = (int)Math.floor(tileX-8)>>4; dx<=(int)Math.floor(tileX+8)>>4; dx++)
				for(int dz = (int)Math.floor(tileZ-8)>>4; dz<=(int)Math.floor(tileZ+8)>>4; dz++)
				{
					Iterator it = ClientUtils.mc().field_71439_g.field_70170_p.func_72964_e(dx, dz).func_177434_r().values().iterator();
					while (it.hasNext())
					{
						TileEntity tile = (TileEntity)it.next();
						if(tile!=null && tile.getClass().getName().endsWith("TileEntitySoundMuffler"))
							if(tile.func_145832_p()!=1)
							{
								double d = tile.func_145835_a(tileX, tileY, tileZ);
								if(d<=64 && d>0)
									volumeAjustment=.1f;
							}
					}
				}

		TileEntity tile = ClientUtils.mc().field_71439_g.field_70170_p.func_175625_s(new BlockPos(tileX,tileY,tileZ));
		if(!(tile instanceof ISoundTile))
			donePlaying = true;
		else
			donePlaying = !((ISoundTile)tile).shoudlPlaySound(resource.toString());
	}


	@Override
	public void func_73660_a()
	{
		if(ClientUtils.mc().field_71439_g!=null && ClientUtils.mc().field_71439_g.field_70170_p.func_82737_E()%40==0)
			evaluateVolume();
	}

	public boolean donePlaying=false;
	@Override
	public boolean func_147667_k()
	{
		return donePlaying;
	}
}
