/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.sound;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

import javax.annotation.Nullable;

import net.minecraft.client.audio.ISound.AttenuationType;

public class IEMuffledSound implements ISound
{
	ISound originalSound;
	float volumeMod;

	public IEMuffledSound(ISound originalSound, float volumeMod)
	{
		this.originalSound = originalSound;
		this.volumeMod = volumeMod;
	}

	@Override
	public ResourceLocation func_147650_b()
	{
		return originalSound.func_147650_b();
	}

	@Nullable
	@Override
	public SoundEventAccessor func_184366_a(SoundHandler handler)
	{
		return originalSound.func_184366_a(handler);
	}
	@Override
	public Sound func_184364_b()
	{
		return originalSound.func_184364_b();
	}
	@Override
	public SoundCategory func_184365_d()
	{
		return originalSound.func_184365_d();
	}

	@Override
	public boolean func_147657_c()
	{
		return originalSound.func_147657_c();
	}
	@Override
	public int func_147652_d()
	{
		return originalSound.func_147652_d();
	}
	@Override
	public float func_147653_e()
	{
		return originalSound.func_147653_e()*volumeMod;
	}
	@Override
	public float func_147655_f()
	{
		return originalSound.func_147655_f();
	}
	@Override
	public float func_147649_g()
	{
		return originalSound.func_147649_g();
	}
	@Override
	public float func_147654_h()
	{
		return originalSound.func_147654_h();
	}
	@Override
	public float func_147651_i()
	{
		return originalSound.func_147651_i();
	}
	@Override
	public AttenuationType func_147656_j()
	{
		return originalSound.func_147656_j();
	}
}
