/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

import javax.annotation.Nonnull;

public class IEInventoryHandler implements IItemHandlerModifiable
{
	int slots;
	IIEInventory inv;
	int slotOffset;
	boolean[] canInsert;
	boolean[] canExtract;

	public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean[] canInsert, boolean[] canExtract)
	{
		this.slots = slots;
		this.inv = inventory;
		this.slotOffset = slotOffset;
		this.canInsert = canInsert;
		this.canExtract = canExtract;
	}
	public IEInventoryHandler(int slots, IIEInventory inventory)
	{
		this(slots,inventory,0, new boolean[slots], new boolean[slots]);
		for(int i=0; i<slots; i++)
			this.canExtract[i] = this.canInsert[i] = true;
	}
	public IEInventoryHandler(int slots, IIEInventory inventory, int slotOffset, boolean canInsert, boolean canExtract)
	{
		this(slots,inventory,slotOffset, new boolean[slots], new boolean[slots]);
		for(int i=0; i<slots; i++)
		{
			this.canInsert[i] = canInsert;
			this.canExtract[i] = canExtract;
		}
	}

	@Override
	public int getSlots()
	{
		return slots;
	}

	@Override
	public ItemStack getStackInSlot(int slot)
	{
		return this.inv.getInventory().get(this.slotOffset + slot);
	}
	@Override
	public ItemStack insertItem(int slot, ItemStack stack, boolean simulate)
	{
		if(!canInsert[slot] || stack.func_190926_b())
			return stack;
		stack = stack.func_77946_l();

		if(!inv.isStackValid(this.slotOffset + slot, stack))
			return stack;
		
		int offsetSlot = this.slotOffset+slot;
		ItemStack currentStack = inv.getInventory().get(offsetSlot);

		if(currentStack.func_190926_b())
		{
			int accepted = Math.min(stack.func_77976_d(), inv.getSlotLimit(offsetSlot));
			if(accepted < stack.func_190916_E())
			{
				if(!simulate)
				{
					inv.getInventory().set(offsetSlot, stack.func_77979_a(accepted));
					inv.doGraphicalUpdates(offsetSlot);
					return stack;
				}
				else
				{
					stack.func_190918_g(accepted);
					return stack;
				}
			}
			else
			{
				if(!simulate)
				{
					inv.getInventory().set(offsetSlot, stack);
					inv.doGraphicalUpdates(offsetSlot);
				}
				return ItemStack.field_190927_a;
			}
		}
		else
		{
			if(!ItemHandlerHelper.canItemStacksStack(stack, currentStack))
				return stack;

			int accepted = Math.min(stack.func_77976_d(), inv.getSlotLimit(offsetSlot)) - currentStack.func_190916_E();
			if(accepted < stack.func_190916_E())
			{
				if(!simulate)
				{
					ItemStack newStack = stack.func_77979_a(accepted);
					newStack.func_190917_f(currentStack.func_190916_E());
					inv.getInventory().set(offsetSlot, newStack);
					inv.doGraphicalUpdates(offsetSlot);
					return stack;
				}
				else
				{
					stack.func_190918_g(accepted);
					return stack;
				}
			}
			else
			{
				if(!simulate)
				{
					ItemStack newStack = stack.func_77946_l();
					newStack.func_190917_f(currentStack.func_190916_E());
					inv.getInventory().set(offsetSlot, newStack);
					inv.doGraphicalUpdates(offsetSlot);
				}
				return ItemStack.field_190927_a;
			}
		}
	}
	@Override
	public ItemStack extractItem(int slot, int amount, boolean simulate)
	{
		if(!canExtract[slot] || amount==0)
			return ItemStack.field_190927_a;

		int offsetSlot = this.slotOffset+slot;
		ItemStack currentStack = inv.getInventory().get(offsetSlot);

		if(currentStack.func_190926_b())
			return ItemStack.field_190927_a;

		int extracted = Math.min(currentStack.func_190916_E(), amount);

		ItemStack copy = currentStack.func_77946_l();
		copy.func_190920_e(extracted);
		if(!simulate)
		{
			if(extracted < currentStack.func_190916_E())
				currentStack.func_190918_g(extracted);
			else
				currentStack = ItemStack.field_190927_a;
			inv.getInventory().set(offsetSlot, currentStack);
			inv.doGraphicalUpdates(offsetSlot);
		}
		return copy;
	}

	@Override
	public int getSlotLimit(int slot) {
		return 64;
	}

	@Override
	public void setStackInSlot(int slot, @Nonnull ItemStack stack)
	{
		inv.getInventory().set(this.slotOffset+slot, stack);
		inv.doGraphicalUpdates(this.slotOffset+slot);
	}
}
