/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.common.gui.ContainerAssembler;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;

/**
 * @author BluSunrize - 08.09.2016
 */
public class AssemblerRecipeTransferHandler implements IRecipeTransferHandler<ContainerAssembler>
{
	@Override
	public Class getContainerClass()
	{
		return ContainerAssembler.class;
	}

	@Nullable
	@Override
	public IRecipeTransferError transferRecipe(@Nonnull ContainerAssembler container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer)
	{
		for(int i = 0; i < 3; i++)
			if(container.tile.patterns[i].recipe == null)
			{
				if(doTransfer)
				{
					IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
					NBTTagList tagList = new NBTTagList();
					NonNullList<ItemStack> convertedInput = NonNullList.func_191197_a(stacks.getGuiIngredients().size() - 1, ItemStack.field_190927_a);
					int j = 0;
					for(IGuiIngredient<ItemStack> ingr : stacks.getGuiIngredients().values())
					{
						if(j > 0)
						{
							List<ItemStack> list = ingr.getAllIngredients();
							if(list != null && list.size() > 0)
								convertedInput.set(j - 1, list.get(0));
						}
						j++;
					}
					for(int slot = 0; slot < Math.min(convertedInput.size(), 9); slot++)
					{
						container.func_75141_a(i * 10 + slot, convertedInput.get(slot));
						NBTTagCompound itemTag = new NBTTagCompound();
						if(!convertedInput.get(slot).func_190926_b())
							convertedInput.get(slot).func_77955_b(itemTag);
						itemTag.func_74768_a("slot", slot);
						tagList.func_74742_a(itemTag);
					}
					NBTTagCompound tag = new NBTTagCompound();
					tag.func_74782_a("patternSync", tagList);
					tag.func_74768_a("recipe", i);
					ImmersiveEngineering.packetHandler.sendToServer(new MessageTileSync(container.tile, tag));
				}
				return null;
			}
		return JEIHelper.jeiHelpers.recipeTransferHandlerHelper().createUserErrorWithTooltip(I18n.func_74838_a(Lib.GUI + "assembler.nospace"));
	}
}
