/*
 * BluSunrize
 * Copyright (c) 2017
 *
 * This code is licensed under "Blu's License of Common Sense"
 * Details can be found in the license file in the root folder of this project
 */

package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.BelljarHandler.DefaultPlantHandler;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.HashSet;

public class ExtraUtilsHelper extends IECompatModule
{
	@Override
	public void preInit()
	{
	}

	@Override
	public void init()
	{
		Item lillySeeds = Item.field_150901_e.func_82594_a(new ResourceLocation("extrautils2:enderlilly"));
		Block lillyBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("extrautils2:enderlilly"));
		Item orchidSeeds = Item.field_150901_e.func_82594_a(new ResourceLocation("extrautils2:redorchid"));
		Block orchidBlock = Block.field_149771_c.func_82594_a(new ResourceLocation("extrautils2:redorchid"));
		if(lillySeeds!=null && lillyBlock!=null)
			registerXUPlant(new ItemStack(lillySeeds), lillyBlock, new ItemStack(Blocks.field_150377_bs), new ItemStack[]{new ItemStack(Items.field_151079_bi)}, 7, .0000125f, false);
		if(orchidSeeds!=null && orchidBlock!=null)
			registerXUPlant(new ItemStack(orchidSeeds), orchidBlock, new ItemStack(Blocks.field_150450_ax), new ItemStack[]{new ItemStack(Items.field_151137_ax)}, 6, .0125f, true);
	}

	@Override
	public void postInit()
	{
	}

	static void registerXUPlant(ItemStack seed, Block block, ItemStack soil, ItemStack[] output, final int maxAge, final float growthStep, final boolean useFertilizer)
	{
		IProperty propGrowth = null;
		final IBlockState state = block.func_176223_P();
		for(IProperty prop : state.func_177227_a())
			if("growth".equals(prop.func_177701_a()))
				propGrowth = prop;
		if(propGrowth!=null)
		{
			IProperty finalPropGrowth = propGrowth;
			DefaultPlantHandler handler = new DefaultPlantHandler()
			{
				private HashSet<ComparableItemStack> validSeeds = new HashSet<>();
				@Override
				protected HashSet<ComparableItemStack> getSeedSet()
				{
					return validSeeds;
				}
				@Override
				public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render)
				{
					return !useFertilizer?growthStep:(growthStep*fertilizer);
				}
				@Override
				@SideOnly(Side.CLIENT)
				public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile)
				{
					return new IBlockState[]{state.func_177226_a(finalPropGrowth, Math.min(maxAge, Math.round(maxAge*growth)))};
				}
			};
			handler.register(seed, output, soil, state);
			BelljarHandler.registerHandler(handler);
		}
	}
}
